/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.ItemStack;

public interface IMaidTask {
    public ResourceLocation getUid();

    public ItemStack getIcon();

    @Nullable
    public SoundEvent getAmbientSound(EntityMaid var1);

    public List<Pair<Integer, Behavior<? super EntityMaid>>> createBrainTasks(EntityMaid var1);

    default public boolean isEnable(EntityMaid maid) {
        return true;
    }

    default public TranslatableComponent getName() {
        return new TranslatableComponent(String.format("task.%s.%s", this.getUid().m_135827_(), this.getUid().m_135815_()));
    }

    default public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.emptyList();
    }

    default public List<String> getDescription(EntityMaid maid) {
        String key = String.format("task.%s.%s.desc", this.getUid().m_135827_(), this.getUid().m_135815_());
        return Lists.newArrayList((Object[])new String[]{key});
    }
}

