/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block.multiblock;

import com.github.tartaricacid.touhoulittlemaid.api.block.IMultiBlock;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityAltar;
import com.github.tartaricacid.touhoulittlemaid.util.PosListData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class MultiBlockAltar
implements IMultiBlock {
    private static final ResourceLocation ALTAR_SOUTH = new ResourceLocation("touhou_little_maid", "altar_south");
    private static final ResourceLocation ALTAR_NORTH = new ResourceLocation("touhou_little_maid", "altar_north");
    private static final ResourceLocation ALTAR_EAST = new ResourceLocation("touhou_little_maid", "altar_east");
    private static final ResourceLocation ALTAR_WEST = new ResourceLocation("touhou_little_maid", "altar_west");
    private static final BlockPos SOUTH_POS = new BlockPos(-4, -3, 0);
    private static final BlockPos NORTH_POS = new BlockPos(-3, -3, -7);
    private static final BlockPos EAST_POS = new BlockPos(0, -3, -3);
    private static final BlockPos WEST_POS = new BlockPos(-7, -3, -4);

    @Override
    public boolean isCoreBlock(BlockState blockState) {
        return blockState.m_60713_(Blocks.f_50108_);
    }

    @Override
    public boolean isMatch(Level world, BlockPos posStart, Direction direction, StructureTemplate template) {
        StructureTemplate.Palette palette = (StructureTemplate.Palette)template.f_74482_.get(0);
        for (StructureTemplate.StructureBlockInfo blockInfo : palette.m_74652_()) {
            if (world.m_8055_(posStart.m_141952_((Vec3i)blockInfo.f_74675_)).equals(blockInfo.f_74676_)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void build(Level worldIn, BlockPos posStart, Direction direction, StructureTemplate template) {
        PosListData posList = new PosListData();
        PosListData canPlaceItemPosList = new PosListData();
        StructureTemplate.Palette palette = (StructureTemplate.Palette)template.f_74482_.get(0);
        for (StructureTemplate.StructureBlockInfo blockInfo : palette.m_74652_()) {
            posList.add(posStart.m_141952_((Vec3i)blockInfo.f_74675_));
            if (blockInfo.f_74675_.m_123342_() != 2 || !blockInfo.f_74676_.m_60713_(Blocks.f_49999_)) continue;
            canPlaceItemPosList.add(posStart.m_141952_((Vec3i)blockInfo.f_74675_));
        }
        BlockPos currentCenterPos = posStart.m_141950_((Vec3i)this.getCenterPos(direction));
        for (StructureTemplate.StructureBlockInfo blockInfo : palette.m_74652_()) {
            BlockPos currentPos = posStart.m_141952_((Vec3i)blockInfo.f_74675_);
            worldIn.m_7731_(currentPos, ((Block)InitBlocks.ALTAR.get()).m_49966_(), 3);
            BlockEntity te = worldIn.m_7702_(currentPos);
            if (!(te instanceof TileEntityAltar)) continue;
            boolean isRender = currentPos.equals((Object)currentCenterPos);
            boolean canPlaceItem = blockInfo.f_74675_.m_123342_() == 2 && blockInfo.f_74676_.m_60713_(Blocks.f_49999_);
            ((TileEntityAltar)te).setForgeData(blockInfo.f_74676_, isRender, canPlaceItem, direction, posList, canPlaceItemPosList);
        }
    }

    @Override
    public boolean directionIsSuitable(Direction direction) {
        return direction != Direction.DOWN && direction != Direction.UP;
    }

    @Override
    public BlockPos getCenterPos(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> SOUTH_POS;
            case Direction.EAST -> WEST_POS;
            case Direction.WEST -> EAST_POS;
            default -> NORTH_POS;
        };
    }

    @Override
    public StructureTemplate getTemplate(ServerLevel world, Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> this.getAltarTemplate(world, ALTAR_SOUTH);
            case Direction.EAST -> this.getAltarTemplate(world, ALTAR_WEST);
            case Direction.WEST -> this.getAltarTemplate(world, ALTAR_EAST);
            default -> this.getAltarTemplate(world, ALTAR_NORTH);
        };
    }

    private StructureTemplate getAltarTemplate(ServerLevel world, ResourceLocation location) {
        return world.m_8875_().m_74341_(location);
    }
}

