/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.script;

import com.github.tartaricacid.touhoulittlemaid.api.animation.IMaidData;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.WorldWrapper;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.BiomeCacheUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public final class EntityMaidWrapper
implements IMaidData {
    private final WorldWrapper world = new WorldWrapper();
    private final float[] handRotation = new float[]{0.0f, 0.0f, 0.0f};
    private float swingProgress;
    private boolean isRiding;
    private EntityMaid maid;

    public void setData(EntityMaid maid, float swingProgress, boolean isRiding) {
        this.maid = maid;
        this.swingProgress = swingProgress;
        this.isRiding = isRiding;
        this.world.setData(maid.f_19853_);
    }

    public void clearData() {
        this.maid = null;
        this.world.clearData();
    }

    @Override
    public WorldWrapper getWorld() {
        return this.world;
    }

    @Override
    public String getTask() {
        return this.maid.getTask().getUid().toString();
    }

    @Override
    public boolean hasHelmet() {
        return !this.maid.m_6844_(EquipmentSlot.HEAD).m_41619_();
    }

    @Override
    public String getHelmet() {
        ResourceLocation res = this.maid.m_6844_(EquipmentSlot.HEAD).m_41720_().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasChestPlate() {
        return !this.maid.m_6844_(EquipmentSlot.CHEST).m_41619_();
    }

    @Override
    public String getChestPlate() {
        ResourceLocation res = this.maid.m_6844_(EquipmentSlot.CHEST).m_41720_().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasLeggings() {
        return !this.maid.m_6844_(EquipmentSlot.LEGS).m_41619_();
    }

    @Override
    public String getLeggings() {
        ResourceLocation res = this.maid.m_6844_(EquipmentSlot.LEGS).m_41720_().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasBoots() {
        return !this.maid.m_6844_(EquipmentSlot.FEET).m_41619_();
    }

    @Override
    public String getBoots() {
        ResourceLocation res = this.maid.m_6844_(EquipmentSlot.FEET).m_41720_().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasItemMainhand() {
        return this.maid.m_21205_().m_41619_();
    }

    @Override
    public String getItemMainhand() {
        ResourceLocation res = this.maid.m_21205_().m_41720_().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasItemOffhand() {
        return this.maid.m_21206_().m_41619_();
    }

    @Override
    public String getItemOffhand() {
        ResourceLocation res = this.maid.m_21206_().m_41720_().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean isBegging() {
        return this.maid.isBegging();
    }

    @Override
    public boolean isSwingingArms() {
        return this.maid.isSwingingArms();
    }

    @Override
    public boolean isRiding() {
        return this.isRiding;
    }

    @Override
    public boolean isSitting() {
        return this.maid.m_21825_();
    }

    @Override
    public boolean hasBackpack() {
        return this.maid.hasBackpack();
    }

    @Override
    public int getBackpackLevel() {
        return this.maid.getBackpackLevel();
    }

    @Override
    public boolean inWater() {
        return this.maid.m_20069_();
    }

    @Override
    public boolean inRain() {
        return this.maid.f_19853_.m_46758_(this.maid.m_142538_());
    }

    @Override
    public boolean isSwingLeftHand() {
        return this.maid.f_20912_ == InteractionHand.OFF_HAND;
    }

    @Override
    public float getSwingProgress() {
        return this.swingProgress;
    }

    @Override
    public float getHealth() {
        return this.maid.m_21223_();
    }

    @Override
    public float getMaxHealth() {
        return this.maid.m_21233_();
    }

    @Override
    public double getArmorValue() {
        return this.maid.m_21133_(Attributes.f_22284_);
    }

    @Override
    public boolean onHurt() {
        return this.maid.f_20916_ > 0;
    }

    @Override
    public boolean isSleep() {
        return this.maid.m_5803_();
    }

    @Override
    public int getFavorability() {
        return this.maid.getFavorability();
    }

    @Override
    public long getSeed() {
        return Math.abs(this.maid.m_142081_().getLeastSignificantBits());
    }

    @Override
    public String getAtBiome() {
        ResourceLocation res = BiomeCacheUtil.getCacheBiome((Entity)this.maid).getRegistryName();
        if (res != null) {
            return res.m_135815_();
        }
        return "";
    }

    @Override
    public boolean isOnGround() {
        return !this.maid.m_20096_();
    }

    @Override
    @Deprecated
    public String getAtBiomeTemp() {
        return this.maid.getAtBiomeTemp();
    }

    @Override
    @Deprecated
    public boolean hasSasimono() {
        return false;
    }

    @Override
    @Deprecated
    public boolean isHoldTrolley() {
        return false;
    }

    @Override
    @Deprecated
    public boolean isRidingMarisaBroom() {
        return false;
    }

    @Override
    public boolean isRidingPlayer() {
        return this.maid.m_20202_() instanceof Player;
    }

    @Override
    @Deprecated
    public boolean isHoldVehicle() {
        return false;
    }

    @Override
    @Deprecated
    public boolean isPortableAudioPlay() {
        return false;
    }

    @Override
    @Deprecated
    public float[] getLeftHandRotation() {
        return this.handRotation;
    }

    @Override
    @Deprecated
    public float[] getRightHandRotation() {
        return this.handRotation;
    }

    @Override
    @Deprecated
    public int getDim() {
        return this.maid.getDim();
    }
}

