/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.download;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.info.ServerCustomPackLoader;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.locale.Language;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="touhou_little_maid", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class InfoGetManager {
    private static final String ROOT_URL = "http://tlm.cfpa.team:29434/";
    private static final String INFO_JSON_URL = "http://tlm.cfpa.team:29434/info.json";
    private static final String INFO_JSON_MD5_URL = "http://tlm.cfpa.team:29434/info.json.md5";
    private static final Path ROOT_FOLDER = InfoGetManager.getRootPath();
    private static final Path INFO_JSON_FILE = ROOT_FOLDER.resolve("info.json");
    private static final Path PACK_FOLDER = ROOT_FOLDER.resolve("file");
    public static List<DownloadInfo> DOWNLOAD_INFO_LIST_ALL = Lists.newArrayList();
    public static List<DownloadInfo> DOWNLOAD_INFO_LIST_MAID = Lists.newArrayList();
    public static List<DownloadInfo> DOWNLOAD_INFO_LIST_CHAIR = Lists.newArrayList();
    public static List<DownloadInfo> DOWNLOAD_INFO_LIST_SOUND = Lists.newArrayList();

    public static void checkInfoJsonFile() {
        if (!ROOT_FOLDER.toFile().isDirectory()) {
            try {
                Files.createDirectories(ROOT_FOLDER, new FileAttribute[0]);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
        }
        if (!INFO_JSON_FILE.toFile().isFile()) {
            InfoGetManager.downloadAndReadInfoJsonFile();
        } else {
            try {
                FileInputStream stream = new FileInputStream(INFO_JSON_FILE.toFile());
                InfoGetManager.downloadAndReadInfoJsonFile(DigestUtils.md5Hex((InputStream)stream));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private static Path getRootPath() {
        if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91069_ != null) {
            return Paths.get(Minecraft.m_91087_().f_91069_.toURI()).resolve("config").resolve("touhou_little_maid");
        }
        return Paths.get("./", new String[0]).resolve("config").resolve("touhou_little_maid");
    }

    private static void downloadAndReadInfoJsonFile() {
        InfoGetManager.downloadAndReadInfoJsonFile(null);
    }

    private static void downloadAndReadInfoJsonFile(@Nullable String md5) {
        Thread thread = new Thread(() -> {
            try {
                File file = INFO_JSON_FILE.toFile();
                if (StringUtils.isNotBlank((CharSequence)md5)) {
                    String md5Remote = IOUtils.toString((URL)new URL(INFO_JSON_MD5_URL), (Charset)StandardCharsets.UTF_8);
                    if (md5Remote.equals(md5)) {
                        TouhouLittleMaid.LOGGER.info("info.json file no update required");
                    } else {
                        TouhouLittleMaid.LOGGER.info("Downloading info.json file...");
                        FileUtils.copyURLToFile((URL)new URL(INFO_JSON_URL), (File)file, (int)30000, (int)30000);
                        TouhouLittleMaid.LOGGER.info("Downloaded info.json file");
                    }
                } else {
                    TouhouLittleMaid.LOGGER.info("Downloading info.json file...");
                    FileUtils.copyURLToFile((URL)new URL(INFO_JSON_URL), (File)file, (int)30000, (int)30000);
                    TouhouLittleMaid.LOGGER.info("Downloaded info.json file");
                }
                DOWNLOAD_INFO_LIST_ALL = (List)CustomPackLoader.GSON.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8), new TypeToken<List<DownloadInfo>>(){}.getType());
                DOWNLOAD_INFO_LIST_ALL.forEach(DownloadInfo::decorate);
                DOWNLOAD_INFO_LIST_ALL.forEach(downloadInfo -> {
                    if (downloadInfo.hasType(DownloadInfo.TypeEnum.MAID)) {
                        DOWNLOAD_INFO_LIST_MAID.add((DownloadInfo)downloadInfo);
                    }
                    if (downloadInfo.hasType(DownloadInfo.TypeEnum.CHAIR)) {
                        DOWNLOAD_INFO_LIST_CHAIR.add((DownloadInfo)downloadInfo);
                    }
                    if (downloadInfo.hasType(DownloadInfo.TypeEnum.SOUND)) {
                        DOWNLOAD_INFO_LIST_SOUND.add((DownloadInfo)downloadInfo);
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, "Download-Info-Json-File");
        thread.start();
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(InfoGetManager::checkInfoJsonFile);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onResourceReload(TextureStitchEvent.Post event) {
        LanguageInfo language = Minecraft.m_91087_().m_91102_().m_118983_();
        Map oldLangData = Language.m_128107_().getLanguageData();
        HashMap newLangData = Maps.newHashMap();
        newLangData.putAll(oldLangData);
        for (DownloadInfo info : DOWNLOAD_INFO_LIST_ALL) {
            HashMap<String, String> langMap = info.getLanguage("en_us");
            for (String key : langMap.keySet()) {
                newLangData.put(key, langMap.get(key));
            }
            String currentLanguage = language.getCode();
            HashMap<String, String> currentLangMap = info.getLanguage(currentLanguage);
            if (currentLangMap == null) continue;
            for (String key : currentLangMap.keySet()) {
                newLangData.put(key, currentLangMap.get(key));
            }
        }
        if (Language.m_128107_() instanceof ClientLanguage) {
            ((ClientLanguage)Language.m_128107_()).f_118910_ = newLangData;
        }
    }

    public static void downloadResourcesPack(DownloadInfo info) {
        Thread thread = new Thread(() -> {
            info.setStatus(DownloadStatus.DOWNLOADING);
            try {
                URL url = new URL(new URL(ROOT_URL), info.getUrl());
                File fileInTlmModel = CustomPackLoader.PACK_FOLDER.resolve(info.getFileName()).toFile();
                File fileInMcRes = Minecraft.m_91087_().f_91069_.toPath().resolve("resourcepacks").resolve(info.getFileName()).toFile();
                File fileInCache = PACK_FOLDER.resolve(info.getFileName()).toFile();
                if (!fileInCache.isFile() || FileUtils.checksumCRC32((File)fileInCache) != info.getChecksum()) {
                    TouhouLittleMaid.LOGGER.info("Downloading {} file...", (Object)info.getFileName());
                    FileUtils.copyURLToFile((URL)url, (File)fileInCache, (int)60000, (int)60000);
                    TouhouLittleMaid.LOGGER.info("Downloaded {} file", (Object)info.getFileName());
                } else {
                    TouhouLittleMaid.LOGGER.info("file {} existed in cache folder", (Object)info.getFileName());
                }
                if (info.hasType(DownloadInfo.TypeEnum.SOUND)) {
                    Files.copy(fileInCache.toPath(), fileInMcRes.toPath(), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.copy(fileInCache.toPath(), fileInTlmModel.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    CustomPackLoader.readModelFromZipFile(fileInTlmModel);
                    ServerCustomPackLoader.reloadPacks();
                }
                info.setStatus(DownloadStatus.DOWNLOADED);
            }
            catch (IOException e) {
                info.setStatus(DownloadStatus.NOT_DOWNLOAD);
                e.printStackTrace();
            }
        }, String.format("Download-Resources-Pack-File-%s", info.getName()));
        thread.start();
    }

    public static List<DownloadInfo> getTypedDownloadInfoList(DownloadInfo.TypeEnum typeEnum) {
        switch (typeEnum) {
            case CHAIR: {
                return DOWNLOAD_INFO_LIST_CHAIR;
            }
            case SOUND: {
                return DOWNLOAD_INFO_LIST_SOUND;
            }
        }
        return DOWNLOAD_INFO_LIST_MAID;
    }
}

