/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.config.InGameMaidConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class MaidSoundFreqEvent {
    private static final String MAID_SOUND_PREFIX = "maid.";

    @SubscribeEvent
    public static void onPlaySoundEvent(PlaySoundEvent event) {
        if (event.getSound() == null) {
            return;
        }
        ResourceLocation location = event.getSound().m_7904_();
        double soundFrequency = InGameMaidConfig.INSTANCE.getSoundFrequency();
        if (soundFrequency < 1.0 && MaidSoundFreqEvent.checkSoundName(location) && Math.random() > soundFrequency) {
            event.setSound(null);
        }
    }

    private static boolean checkSoundName(ResourceLocation name) {
        return name.m_135827_().equals("touhou_little_maid") && name.m_135815_().startsWith(MAID_SOUND_PREFIX);
    }
}

