/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.block;

import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.BeaconEffectButton;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetBeaconOverflowMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.StorageAndTakePowerMessage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import com.github.tartaricacid.touhoulittlemaid.util.ShapeDraw;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class MaidBeaconGui
extends Screen {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/maid_beacon.png");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private final TileEntityMaidBeacon beacon;
    protected int imageWidth = 256;
    protected int imageHeight = 105;
    protected int leftPos;
    protected int topPos;
    private boolean overflowDelete;
    private int potionIndex;

    public MaidBeaconGui(TileEntityMaidBeacon beacon) {
        super((Component)new TextComponent("Maid Beacon GUI"));
        this.beacon = beacon;
        this.overflowDelete = beacon.isOverflowDelete();
        this.potionIndex = beacon.getPotionIndex();
    }

    protected void m_7856_() {
        this.m_169413_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        int start = this.leftPos + 16;
        int spacing = 26;
        int y = this.topPos + 15;
        this.addEffectButton(start, spacing, y);
        this.addStorageAndTakeButton();
        this.m_142416_((GuiEventListener)new Button(this.leftPos + 7, this.topPos - 22, 242, 20, (Component)this.getOverflowDeleteButtonText(this.overflowDelete), b -> {
            this.overflowDelete = !this.overflowDelete;
            NetworkHandler.CHANNEL.sendToServer((Object)new SetBeaconOverflowMessage(this.beacon.m_58899_(), this.overflowDelete));
            this.m_7856_();
        }));
    }

    private void addStorageAndTakeButton() {
        this.m_142416_((GuiEventListener)new Button(this.leftPos + 16, this.topPos + 48, 62, 20, (Component)new TranslatableComponent("gui.touhou_little_maid.maid_beacon.add_one"), b -> NetworkHandler.CHANNEL.sendToServer((Object)new StorageAndTakePowerMessage(this.beacon.m_58899_(), 1.0f, true))));
        this.m_142416_((GuiEventListener)new Button(this.leftPos + 80, this.topPos + 48, 62, 20, (Component)new TranslatableComponent("gui.touhou_little_maid.maid_beacon.add_all"), b -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                player.getCapability(PowerCapabilityProvider.POWER_CAP).ifPresent(power -> NetworkHandler.CHANNEL.sendToServer((Object)new StorageAndTakePowerMessage(this.beacon.m_58899_(), power.get(), true)));
            }
        }));
        this.m_142416_((GuiEventListener)new Button(this.leftPos + 16, this.topPos + 70, 62, 20, (Component)new TranslatableComponent("gui.touhou_little_maid.maid_beacon.min_one"), b -> NetworkHandler.CHANNEL.sendToServer((Object)new StorageAndTakePowerMessage(this.beacon.m_58899_(), 1.0f, false))));
        this.m_142416_((GuiEventListener)new Button(this.leftPos + 80, this.topPos + 70, 62, 20, (Component)new TranslatableComponent("gui.touhou_little_maid.maid_beacon.min_all"), b -> NetworkHandler.CHANNEL.sendToServer((Object)new StorageAndTakePowerMessage(this.beacon.m_58899_(), this.beacon.getStoragePower(), false))));
    }

    private void addEffectButton(int start, int spacing, int y) {
        this.m_142416_((GuiEventListener)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.SPEED, start, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.SPEED.ordinal() : -1;
            this.m_7856_();
        }));
        this.m_142416_((GuiEventListener)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.FIRE_RESISTANCE, start + spacing, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.FIRE_RESISTANCE.ordinal() : -1;
            this.m_7856_();
        }));
        this.m_142416_((GuiEventListener)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.STRENGTH, start + spacing * 2, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.STRENGTH.ordinal() : -1;
            this.m_7856_();
        }));
        this.m_142416_((GuiEventListener)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.RESISTANCE, start + spacing * 3, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.RESISTANCE.ordinal() : -1;
            this.m_7856_();
        }));
        this.m_142416_((GuiEventListener)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.REGENERATION, start + spacing * 4, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.REGENERATION.ordinal() : -1;
            this.m_7856_();
        }));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BG);
        this.m_93228_(poseStack, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.renderPlayerPower(poseStack);
        MaidBeaconGui.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"gui.touhou_little_maid.maid_beacon.storage_power", (Object[])new Object[]{DECIMAL_FORMAT.format(this.beacon.getStoragePower())}), (int)(this.leftPos + 198), (int)(this.topPos + 22), (int)0xFFFFFF);
        if (this.potionIndex == -1) {
            MaidBeaconGui.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"gui.touhou_little_maid.maid_beacon.cost_power", (Object[])new Object[]{DECIMAL_FORMAT.format(0L)}), (int)(this.leftPos + 198), (int)(this.topPos + 32), (int)0xFFFFFF);
        } else {
            MaidBeaconGui.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TranslatableComponent("gui.touhou_little_maid.maid_beacon.cost_power", new Object[]{DECIMAL_FORMAT.format(this.beacon.getEffectCost() * 900.0f)}).m_130940_(ChatFormatting.RED), (int)(this.leftPos + 198), (int)(this.topPos + 32), (int)0xFFFFFF);
        }
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        ShapeDraw.drawCircle(this.leftPos + 180, this.topPos + 70, 20, 64, 570846061);
        ShapeDraw.drawSector(this.leftPos + 180, this.topPos + 70, 22, 0.0, (double)(this.beacon.getStoragePower() / this.beacon.getMaxStorage() * 2.0f) * Math.PI, 64, -12524315);
        MaidBeaconGui.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)String.format("%.2f%%", Float.valueOf(this.beacon.getStoragePower() / this.beacon.getMaxStorage() * 100.0f)), (int)(this.leftPos + 223), (int)(this.topPos + 66), (int)0xFFFFFF);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.f_96541_ != null && this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void renderPlayerPower(PoseStack poseStack) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.getCapability(PowerCapabilityProvider.POWER_CAP).ifPresent(power -> MaidBeaconGui.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"gui.touhou_little_maid.maid_beacon.player_power", (Object[])new Object[]{DECIMAL_FORMAT.format(power.get())}), (int)(this.leftPos + 198), (int)(this.topPos + 10 + 2), (int)0xFFFFFF));
        }
    }

    private TranslatableComponent getOverflowDeleteButtonText(boolean overflowDelete) {
        return overflowDelete ? new TranslatableComponent("gui.touhou_little_maid.maid_beacon.overflow_delete_true") : new TranslatableComponent("gui.touhou_little_maid.maid_beacon.overflow_delete_false");
    }
}

