/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.block;

import com.github.tartaricacid.touhoulittlemaid.client.gui.block.ModelSwitcherModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.DirectButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ImageButtonWithId;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SaveSwitcherDataMessage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class ModelSwitcherGui
extends Screen {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/model_switcher.png");
    private static final ResourceLocation DEFAULT_MODEL_ID = new ResourceLocation("touhou_little_maid:hakurei_reimu");
    private final List<TileEntityModelSwitcher.ModeInfo> infoList;
    private final BlockPos pos;
    private final int maxRow = 6;
    private final UUID bindUuid;
    protected int imageWidth = 256;
    protected int imageHeight = 166;
    protected int leftPos;
    protected int topPos;
    private EntityMaid maid = null;
    private EditBox description;
    private int selectedIndex = -1;
    private int page;

    public ModelSwitcherGui(TileEntityModelSwitcher switcher) {
        super((Component)new TextComponent("Model Switcher GUI"));
        this.infoList = switcher.getInfoList();
        this.pos = switcher.m_58899_();
        this.bindUuid = switcher.getUuid();
        if (Minecraft.m_91087_().f_91073_ != null) {
            this.maid = new EntityMaid((Level)Minecraft.m_91087_().f_91073_);
        }
    }

    protected void m_7856_() {
        this.getMinecraft().f_91068_.m_90926_(true);
        this.m_169413_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.selectedIndex = this.selectedIndex < this.infoList.size() ? this.selectedIndex : -1;
        this.page = this.page <= (this.infoList.size() - 1) / 6 ? this.page : 0;
        this.addListChangeButton();
        this.addPageButton();
        this.addListButton();
        if (this.selectedIndex >= 0) {
            this.addEditButton();
        } else {
            this.description = null;
        }
    }

    private void addEditButton() {
        TileEntityModelSwitcher.ModeInfo info = this.infoList.get(this.selectedIndex);
        this.maid.setModelId(info.getModelId().toString());
        this.m_142416_((GuiEventListener)new Button(this.leftPos + 55, this.topPos + 15, 76, 20, (Component)new TranslatableComponent("gui.touhou_little_maid.button.skin"), b -> {
            ModelSwitcherModelGui modelGui = new ModelSwitcherModelGui(this.maid, info, this);
            this.getMinecraft().m_91152_((Screen)modelGui);
        }));
        this.m_142416_((GuiEventListener)new DirectButton(this.leftPos + 55, this.topPos + 38, 76, 20, info.getDirection(), b -> info.setDirection(((DirectButton)b).getDirection())));
        this.m_142416_((GuiEventListener)new Button(this.leftPos + 12, this.topPos + 135, 121, 20, (Component)new TranslatableComponent("selectWorld.edit.save"), b -> NetworkHandler.CHANNEL.sendToServer((Object)new SaveSwitcherDataMessage(this.pos, this.infoList))));
        this.description = new EditBox(this.getMinecraft().f_91062_, this.leftPos + 12, this.topPos + 65, 119, 20, (Component)new TranslatableComponent("gui.touhou_little_maid.name_tag.edit_box"));
        this.description.m_94144_(info.getText());
        this.m_7787_((GuiEventListener)this.description);
        this.m_94718_((GuiEventListener)this.description);
    }

    private void addListButton() {
        int startOffsetY = this.topPos + 24;
        for (int i = this.page * 6; i < Math.min(this.infoList.size(), (this.page + 1) * 6); ++i) {
            ImageButtonWithId button = i != this.selectedIndex ? new ImageButtonWithId(i, this.leftPos + 141, startOffsetY, 108, 19, 0, 166, 19, BG, b -> {
                this.selectedIndex = ((ImageButtonWithId)b).getIndex();
                this.m_7856_();
            }) : new ImageButtonWithId(i, this.leftPos + 141, startOffsetY, 108, 19, 108, 166, 0, BG, b -> {
                this.selectedIndex = -1;
                this.m_7856_();
            });
            this.m_142416_((GuiEventListener)button);
            startOffsetY += 19;
        }
    }

    private void addPageButton() {
        this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 141, this.topPos + 7, 13, 16, 0, 204, 16, BG, b -> {
            if (this.page > 0) {
                --this.page;
                this.m_7856_();
            }
        }));
        this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 236, this.topPos + 7, 13, 16, 13, 204, 16, BG, b -> {
            if (this.page + 1 <= (this.infoList.size() - 1) / 6) {
                ++this.page;
                this.m_7856_();
            }
        }));
    }

    private void addListChangeButton() {
        this.m_142416_((GuiEventListener)new Button(this.leftPos + 141, this.topPos + 139, 53, 20, (Component)new TranslatableComponent("gui.touhou_little_maid.model_switcher.list.add"), b -> {
            this.infoList.add(new TileEntityModelSwitcher.ModeInfo(DEFAULT_MODEL_ID, "", Direction.NORTH));
            this.m_7856_();
        }));
        this.m_142416_((GuiEventListener)new Button(this.leftPos + 196, this.topPos + 139, 53, 20, (Component)new TranslatableComponent("selectWorld.deleteButton"), b -> {
            if (-1 < this.selectedIndex && this.selectedIndex < this.infoList.size()) {
                this.infoList.remove(this.selectedIndex);
                this.selectedIndex = -1;
                this.m_7856_();
            }
        }));
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        String value = "";
        if (this.description != null) {
            value = this.description.m_94155_();
        }
        super.m_6574_(pMinecraft, this.f_96543_, this.f_96544_);
        if (this.description != null) {
            this.description.m_94144_(value);
        }
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.maid == null) {
            return;
        }
        this.m_7333_(pPoseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BG);
        this.m_93228_(pPoseStack, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (this.bindUuid != null) {
            ModelSwitcherGui.m_93208_((PoseStack)pPoseStack, (Font)this.f_96547_, (String)this.bindUuid.toString(), (int)(this.leftPos + 128), (int)(this.topPos - 10), (int)0xFFFFFF);
        } else {
            ModelSwitcherGui.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)new TranslatableComponent("gui.touhou_little_maid.model_switcher.uuid.empty"), (int)(this.leftPos + 128), (int)(this.topPos - 10), (int)0xFFFFFF);
        }
        ModelSwitcherGui.m_93208_((PoseStack)pPoseStack, (Font)this.f_96547_, (String)String.format("%d/%d", this.page + 1, (this.infoList.size() - 1) / 6 + 1), (int)(this.leftPos + 193), (int)(this.topPos + 12), (int)0xFFFFFF);
        if (this.description != null) {
            InventoryScreen.m_98850_((int)(this.leftPos + 30), (int)(this.topPos + 60), (int)25, (float)(this.leftPos - 150), (float)(this.topPos - 50), (LivingEntity)this.maid);
            this.description.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.renderListButtonName(pPoseStack);
    }

    private void renderListButtonName(PoseStack pPoseStack) {
        int startOffsetY = this.topPos + 29;
        for (int i = this.page * 6; i < Math.min(this.infoList.size(), (this.page + 1) * 6); ++i) {
            String modelId = this.infoList.get(i).getModelId().toString();
            if (CustomPackLoader.MAID_MODELS.getInfo(modelId).isPresent()) {
                MaidModelInfo info = CustomPackLoader.MAID_MODELS.getInfo(modelId).get();
                TranslatableComponent component = new TranslatableComponent(ParseI18n.getI18nKey(info.getName()));
                ModelSwitcherGui.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)component, (int)(this.leftPos + 193), (int)startOffsetY, (int)0xFFFFFF);
            }
            startOffsetY += 19;
        }
    }

    public void m_96624_() {
        if (this.description != null) {
            this.description.m_94120_();
            if (0 <= this.selectedIndex && this.selectedIndex < this.infoList.size()) {
                this.infoList.get(this.selectedIndex).setText(this.description.m_94155_());
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.description != null && this.description.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.description);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_6697_(String text, boolean overwrite) {
        if (this.description != null) {
            if (overwrite) {
                this.description.m_94144_(text);
            } else {
                this.description.m_94164_(text);
            }
        }
    }

    public void m_7379_() {
        NetworkHandler.CHANNEL.sendToServer((Object)new SaveSwitcherDataMessage(this.pos, this.infoList));
        super.m_7379_();
    }
}

