/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity;

import com.github.tartaricacid.touhoulittlemaid.client.download.InfoGetManager;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ButtonWithId;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.GuiDownloadButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ImageButtonWithId;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.commons.io.FileUtils;

public class ModelDownloadGui
extends Screen {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/download_background.png");
    private static float scroll;
    private static int startIndex;
    private static int index;
    private static int currentPage;
    private List<Long> crc32List = Lists.newArrayList();
    private List<DownloadInfo> showInfoList;

    public ModelDownloadGui(@Nullable List<DownloadInfo> showInfoList) {
        super((Component)new TextComponent("Model Pack Download GUI"));
        this.showInfoList = showInfoList;
        if (showInfoList != null && !showInfoList.isEmpty()) {
            this.getCrc32Info();
            this.checkDownloadInfo();
            this.calculationStartIndex();
        }
    }

    public static int getCurrentPage() {
        return currentPage;
    }

    protected void m_7856_() {
        int i;
        this.m_169413_();
        int startX = this.f_96543_ / 2 - 194;
        int startY = this.f_96544_ / 2 - 79;
        if (this.showInfoList == null || this.showInfoList.isEmpty()) {
            this.m_142416_((GuiEventListener)new Button(5, 5, 60, 20, (Component)new TranslatableComponent("gui.touhou_little_maid.resources_download.reload"), b -> {}));
            return;
        }
        for (i = startIndex; i < 9 + startIndex; ++i) {
            if (i >= this.showInfoList.size()) continue;
            DownloadInfo info = this.showInfoList.get(i);
            ButtonWithId button = new ButtonWithId(i, startX, startY + 21 * (i - startIndex), 171, 20, (Component)new TranslatableComponent(info.getName()), id -> {
                index = id;
                this.m_7856_();
            });
            if (i == index) {
                button.f_93623_ = false;
            }
            this.m_142416_((GuiEventListener)button);
        }
        this.m_142416_((GuiEventListener)new GuiDownloadButton(startX + 184, startY + 165, 200, 20, this.showInfoList.get(index)));
        for (i = 0; i < 4; ++i) {
            this.m_142416_((GuiEventListener)new ImageButtonWithId(i, startX - 1 + 28 * i, startY - 30, 25, 25, 480, 0, 0, BG, b -> {
                int pageIndex = ((ImageButtonWithId)b).getIndex();
                if (this.f_96541_ != null && currentPage != pageIndex) {
                    currentPage = pageIndex;
                    startIndex = 0;
                    scroll = 0.0f;
                    DownloadInfo.TypeEnum typeEnum = DownloadInfo.TypeEnum.getTypeByIndex(pageIndex - 1);
                    List<DownloadInfo> downloadInfos = InfoGetManager.getTypedDownloadInfoList(typeEnum);
                    this.f_96541_.m_91152_((Screen)new ModelDownloadGui(downloadInfos));
                }
            }));
        }
        this.m_142416_((GuiEventListener)new Button(startX + 287, startY - 30, 100, 20, (Component)new TranslatableComponent("spectatorMenu.close"), b -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(null);
            }
        }));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        boolean inRangeY;
        int middleX = this.f_96543_ / 2;
        int middleY = this.f_96544_ / 2;
        this.m_7333_(poseStack);
        if (this.f_96541_ == null || this.showInfoList == null || this.showInfoList.isEmpty()) {
            ModelDownloadGui.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TranslatableComponent("gui.touhou_little_maid.resources_download.fail.1"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 15), (int)1048575);
            ModelDownloadGui.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TranslatableComponent("gui.touhou_little_maid.resources_download.fail.2"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)1048575);
        } else {
            int i;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)BG);
            ModelDownloadGui.m_93133_((PoseStack)poseStack, (int)(middleX - 200), (int)(middleY - 85), (float)0.0f, (float)0.0f, (int)400, (int)200, (int)484, (int)256);
            ModelDownloadGui.m_93133_((PoseStack)poseStack, (int)(middleX - 19), (int)(middleY - 77 + (int)(169.0f * scroll)), (float)400.0f, (float)0.0f, (int)4, (int)15, (int)484, (int)256);
            for (i = 0; i < 4; ++i) {
                ModelDownloadGui.m_93133_((PoseStack)poseStack, (int)(middleX - 196 + 28 * i), (int)(middleY - 110), (float)456.0f, (float)194.0f, (int)28, (int)25, (int)484, (int)256);
            }
            ModelDownloadGui.m_93133_((PoseStack)poseStack, (int)(middleX - 196 + 28 * currentPage), (int)(middleY - 113), (float)456.0f, (float)224.0f, (int)28, (int)32, (int)484, (int)256);
            for (i = 0; i < 4; ++i) {
                ModelDownloadGui.m_93160_((PoseStack)poseStack, (int)(middleX - 192 + 28 * i), (int)(middleY - 106), (int)20, (int)20, (float)(i * 32), (float)224.0f, (int)32, (int)32, (int)484, (int)256);
            }
            this.addResInfo(poseStack, this.showInfoList.get(index));
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        boolean inRangeX = middleX - 196 <= mouseX && mouseX < middleX - 196 + 112;
        boolean bl = inRangeY = middleY - 110 <= mouseY && mouseY < middleY - 110 + 25;
        if (inRangeX && inRangeY) {
            int index = (mouseX - (middleX - 196)) / 28;
            this.m_96602_(poseStack, (Component)new TranslatableComponent("gui.touhou_little_maid.resources_download.tab." + index), mouseX, mouseY);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta != 0.0) {
            if (this.showInfoList.size() <= 9) {
                return true;
            }
            float num = delta < 0.0 ? 1.0f : -1.0f;
            scroll = Mth.m_14036_((float)(scroll + num / (float)(this.showInfoList.size() - 9)), (float)0.0f, (float)1.0f);
            if ((startIndex += (int)num) < 0) {
                startIndex = 0;
            }
            if (startIndex > this.showInfoList.size() - 9) {
                startIndex = this.showInfoList.size() - 9;
            }
            this.m_7856_();
            return true;
        }
        return false;
    }

    private void addResInfo(PoseStack poseStack, DownloadInfo info) {
        int startX = this.f_96543_ / 2 - 7;
        int startY = this.f_96544_ / 2 - 73;
        TranslatableComponent name = new TranslatableComponent(info.getName());
        ModelDownloadGui.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)name, (int)startX, (int)startY, (int)0xFFAA00);
        ModelDownloadGui.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)info.getVersion(), (int)(startX + this.f_96547_.m_92852_((FormattedText)name) + 4), (int)startY, (int)0x55FF55);
        ModelDownloadGui.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.getI18nFormatFileSize(info.getFormatFileSize()), (int)startX, (int)(startY + 12), (int)3837879);
        ModelDownloadGui.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.getI18nFormatFileTime(info.getFormatData()), (int)startX, (int)(startY + 24), (int)0x55FFFF);
        ModelDownloadGui.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.getI18nFormatAuthor(info.getAuthor()), (int)startX, (int)(startY + 36), (int)35180);
        ModelDownloadGui.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.getI18nFormatLicense(info.getLicense()), (int)startX, (int)(startY + 48), (int)16243020);
        this.f_96547_.m_92857_((FormattedText)new TranslatableComponent(info.getDesc()), startX, startY + 72, 195, 0x7A7A7A);
    }

    private void getCrc32Info() {
        try {
            Files.walkFileTree(CustomPackLoader.PACK_FOLDER, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(".zip")) {
                        ModelDownloadGui.this.crc32List.add(FileUtils.checksumCRC32((File)file.toFile()));
                    }
                    return super.visitFile(file, attrs);
                }
            });
            Files.walkFileTree(Minecraft.m_91087_().f_91069_.toPath().resolve("resourcepacks"), EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(".zip")) {
                        ModelDownloadGui.this.crc32List.add(FileUtils.checksumCRC32((File)file.toFile()));
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkDownloadInfo() {
        block0: for (DownloadInfo info : this.showInfoList) {
            if (info.getStatus() == DownloadStatus.DOWNLOADING) continue;
            info.setStatus(DownloadStatus.NOT_DOWNLOAD);
            for (Long crc32 : this.crc32List) {
                if (!crc32.equals(info.getChecksum())) continue;
                info.setStatus(DownloadStatus.DOWNLOADED);
                continue block0;
            }
        }
    }

    private void calculationStartIndex() {
        int size = this.showInfoList.size();
        index = Mth.m_14045_((int)index, (int)0, (int)(size - 1));
        if (size - 9 > 0 && startIndex > size - 9) {
            startIndex = size - 9;
        }
    }

    private String getI18nFormatAuthor(List<String> authors) {
        String str = String.join((CharSequence)I18n.m_118938_((String)"gui.touhou_little_maid.resources_download.author.delimiter", (Object[])new Object[0]), authors);
        return I18n.m_118938_((String)"gui.touhou_little_maid.resources_download.author", (Object[])new Object[]{str});
    }

    private String getI18nFormatFileSize(String size) {
        return I18n.m_118938_((String)"gui.touhou_little_maid.resources_download.file_size", (Object[])new Object[]{size});
    }

    private String getI18nFormatFileTime(String time) {
        return I18n.m_118938_((String)"gui.touhou_little_maid.resources_download.upload_time", (Object[])new Object[]{time});
    }

    private String getI18nFormatLicense(String license) {
        return I18n.m_118938_((String)"gui.touhou_little_maid.resources_download.license", (Object[])new Object[]{license});
    }
}

