/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.SkinGuiNumber;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ImageButtonWithId;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public abstract class AbstractModelGui<T extends LivingEntity, E extends IModelInfo>
extends Screen {
    public static final Button.OnPress NO_PRESS = b -> {};
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/skin_select.png");
    private static final ResourceLocation SIDE = new ResourceLocation("touhou_little_maid", "textures/gui/skin_select_side.png");
    protected final T entity;
    private final SkinGuiNumber<E> guiNumber;
    private final List<CustomModelPack<E>> modelPackList;

    public AbstractModelGui(T entity, List<CustomModelPack<E>> listPack) {
        super((Component)new TextComponent("Custom Model GUI"));
        this.entity = entity;
        this.modelPackList = listPack;
        this.guiNumber = new SkinGuiNumber(this.modelPackList);
        this.setPageIndex(Mth.m_14045_((int)this.getPageIndex(), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
        this.setPackIndex(Mth.m_14045_((int)this.getPackIndex(), (int)0, (int)(this.guiNumber.getPackSize() - 1)));
        this.setRowIndex(Mth.m_14045_((int)this.getRowIndex(), (int)0, (int)this.guiNumber.getRowSize(this.getPackIndex())));
    }

    protected abstract void drawLeftEntity(int var1, int var2, float var3, float var4);

    protected abstract void drawRightEntity(int var1, int var2, E var3);

    protected abstract void openDetailsGui(T var1, E var2);

    protected abstract void notifyModelChange(T var1, E var2);

    protected abstract int getPackIndex();

    protected abstract void setPackIndex(int var1);

    protected abstract int getRowIndex();

    protected abstract void setRowIndex(int var1);

    protected abstract int getPageIndex();

    protected abstract void setPageIndex(int var1);

    public void m_7856_() {
        this.m_169413_();
        int startX = this.f_96543_ / 2 + 50;
        int startY = this.f_96544_ / 2 + 5;
        for (int index = 0; index < 7; ++index) {
            this.addTabButton(startX, startY, index);
        }
        this.m_142416_((GuiEventListener)new ImageButton(startX + 122, startY - 97, 21, 17, 58, 201, 18, BG, b -> this.getMinecraft().m_18707_(() -> this.getMinecraft().m_91152_(null))));
        this.addPageButton(startX, startY);
        this.addModelButton(startX, startY);
    }

    private void addModelButton(int startX, int startY) {
        CustomModelPack<E> pack = this.modelPackList.get(this.getPackIndex());
        int offsetX = -100;
        int offsetY = -35;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        int toIndex = this.guiNumber.modelToIndex(this.getPackIndex(), this.getRowIndex());
        for (IModelInfo modelItem : pack.getModelList().subList(fromIndex, toIndex)) {
            this.m_142416_((GuiEventListener)new ImageButton(startX + offsetX - 8, startY + offsetY - 26, 15, 24, 41, 201, 24, BG, this.onModelButtonClick(modelItem)));
            if ((offsetX += 20) <= 105) continue;
            offsetX = -100;
            offsetY += 30;
        }
    }

    private Button.OnPress onModelButtonClick(E modelItem) {
        return button -> {
            if (AbstractModelGui.m_96638_()) {
                this.openDetailsGui(this.entity, modelItem);
            } else {
                this.notifyModelChange(this.entity, modelItem);
            }
        };
    }

    private void addPageButton(int startX, int startY) {
        Button prePage = new Button(startX - 119, startY - 101, 20, 20, (Component)new TextComponent("<"), b -> {
            this.setRowIndex(0);
            this.setPageIndex(Mth.m_14045_((int)(this.getPageIndex() - 1), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
            this.setPackIndex(this.guiNumber.tabToPackIndex(0, this.getPageIndex()));
            this.m_7856_();
        });
        Button nextPage = new Button(startX + 99, startY - 101, 20, 20, (Component)new TextComponent(">"), b -> {
            this.setRowIndex(0);
            this.setPageIndex(Mth.m_14045_((int)(this.getPageIndex() + 1), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
            this.setPackIndex(this.guiNumber.tabToPackIndex(0, this.getPageIndex()));
            this.m_7856_();
        });
        if (this.getPageIndex() == 0) {
            prePage.f_93623_ = false;
        }
        if (this.getPageIndex() == this.guiNumber.getPageSize() - 1) {
            nextPage.f_93623_ = false;
        }
        this.m_142416_((GuiEventListener)prePage);
        this.m_142416_((GuiEventListener)nextPage);
    }

    private void addTabButton(int startX, int startY, int index) {
        if (index == this.guiNumber.getTabIndex(this.getPackIndex())) {
            this.m_142416_((GuiEventListener)new ImageButton(startX - 98 + 28 * index, startY - 108, 28, 31, 116, 224, 0, BG, NO_PRESS));
        } else if (index < this.guiNumber.getTabSize(this.getPackIndex())) {
            this.m_142416_((GuiEventListener)new ImageButtonWithId(index, startX - 98 + 28 * index, startY - 105, 28, 25, 116, 194, 0, BG, b -> {
                this.setRowIndex(0);
                this.setPackIndex(this.guiNumber.tabToPackIndex(((ImageButtonWithId)b).getIndex(), this.getPageIndex()));
                this.m_7856_();
            }));
        } else {
            ImageButton buttonImage = new ImageButton(startX - 98 + 28 * index, startY - 105, 28, 25, 116, 194, 0, BG, NO_PRESS);
            buttonImage.f_93624_ = false;
            this.m_142416_((GuiEventListener)buttonImage);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        poseStack.m_85837_(0.0, 0.0, -100.0);
        int middleX = this.f_96543_ / 2 + 50;
        int middleY = this.f_96544_ / 2 + 5;
        this.m_7333_(poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BG);
        this.m_93228_(poseStack, middleX - 128, middleY - 80, 0, 0, 256, 180);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SIDE);
        this.m_93228_(poseStack, middleX - 128 + 250, middleY - 80, 0, 0, 24, 180);
        this.drawScrollSide(poseStack, middleX, middleY);
        this.drawButton(poseStack, mouseX, mouseY, partialTicks);
        this.drawTabIcon(poseStack, middleX, middleY);
        double scale = this.getMinecraft().m_91268_().m_85449_();
        RenderSystem.m_69488_((int)0, (int)0, (int)((int)((double)(middleX - 128) * scale)), (int)((int)((double)this.f_96544_ * scale)));
        this.drawLeftEntity(middleX, middleY, mouseX, mouseY);
        RenderSystem.m_69471_();
        this.drawEntity(poseStack, middleX, middleY);
        this.drawTooltips(poseStack, mouseX, mouseY, middleX, middleY);
    }

    private void drawButton(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        for (Widget button : this.f_169369_) {
            button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    private void drawScrollSide(PoseStack poseStack, int middleX, int middleY) {
        if (this.guiNumber.canScroll(this.getPackIndex(), this.getRowIndex())) {
            this.m_93228_(poseStack, middleX - 128 + 254, middleY - 72 + (int)(149.0f * this.guiNumber.getCurrentScroll(this.getPackIndex(), this.getRowIndex())), 24, 0, 12, 15);
        } else {
            this.m_93228_(poseStack, middleX - 128 + 254, middleY - 72 + (int)(149.0f * this.guiNumber.getCurrentScroll(this.getPackIndex(), this.getRowIndex())), 36, 0, 12, 15);
        }
    }

    private void drawTabIcon(PoseStack poseStack, int middleX, int middleY) {
        int size = this.guiNumber.getTabSize(this.getPackIndex());
        for (int index = 0; index < size; ++index) {
            CustomModelPack<E> pack = this.modelPackList.get(this.guiNumber.tabToPackIndex(index, this.getPageIndex()));
            ResourceLocation icon = pack.getIcon();
            if (icon == null) continue;
            if (pack.getIconAnimation() == CustomModelPack.AnimationState.UNCHECK) {
                this.checkIconAnimation(pack, icon);
            }
            if (pack.getIconAnimation() == CustomModelPack.AnimationState.FALSE) {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
                AbstractModelGui.m_93133_((PoseStack)poseStack, (int)(middleX - 92 + 28 * index), (int)(middleY - 98), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                continue;
            }
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
            int time = this.getTickTime() / pack.getIconDelay();
            int iconIndex = time % pack.getIconAspectRatio();
            AbstractModelGui.m_93133_((PoseStack)poseStack, (int)(middleX - 92 + 28 * index), (int)(middleY - 98), (float)0.0f, (float)(iconIndex * 16), (int)16, (int)16, (int)16, (int)(16 * pack.getIconAspectRatio()));
        }
    }

    private int getTickTime() {
        return (int)System.currentTimeMillis() / 50;
    }

    private void checkIconAnimation(CustomModelPack<E> pack, ResourceLocation icon) {
        AbstractTexture iconText = this.getMinecraft().f_90987_.m_118506_(icon);
        if (iconText instanceof SizeTexture) {
            int height;
            int width = ((SizeTexture)iconText).getWidth();
            if (width >= (height = ((SizeTexture)iconText).getHeight())) {
                pack.setIconAnimation(CustomModelPack.AnimationState.FALSE);
            } else {
                pack.setIconAnimation(CustomModelPack.AnimationState.TRUE);
                pack.setIconAspectRatio(height / width);
            }
        } else {
            pack.setIconAnimation(CustomModelPack.AnimationState.FALSE);
        }
    }

    private void drawEntity(PoseStack poseStack, int middleX, int middleY) {
        CustomModelPack<E> pack = this.modelPackList.get(this.getPackIndex());
        this.drawPackInfoText(poseStack, pack, middleX, middleY);
        int offsetX = -100;
        int offsetY = -38;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        int toIndex = this.guiNumber.modelToIndex(this.getPackIndex(), this.getRowIndex());
        for (IModelInfo modelItem : pack.getModelList().subList(fromIndex, toIndex)) {
            this.drawRightEntity(middleX + offsetX, middleY + offsetY, modelItem);
            if ((offsetX += 20) <= 105) continue;
            offsetX = -100;
            offsetY += 30;
        }
    }

    private void drawPackInfoText(PoseStack poseStack, CustomModelPack<E> pack, int middleX, int middleY) {
        int offsetY = -80;
        int sideMiddleX = (middleX - 128) / 2;
        MutableComponent packName = ParseI18n.parse(pack.getPackName());
        List packSplitName = this.f_96547_.m_92865_().m_92414_((FormattedText)packName, middleX - 128 - 20, Style.f_131099_);
        for (FormattedText properties : packSplitName) {
            AbstractModelGui.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)properties.getString(), (int)sideMiddleX, (int)(middleY + (offsetY += 10)), (int)0xFFFFFF);
        }
        for (Component str : ParseI18n.parse(pack.getDescription())) {
            List split = this.f_96547_.m_92865_().m_92414_((FormattedText)str, middleX - 128 - 20, Style.f_131099_);
            for (FormattedText properties : split) {
                AbstractModelGui.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)properties.getString(), (int)sideMiddleX, (int)(middleY + (offsetY += 10)), (int)ChatFormatting.DARK_GRAY.m_126665_());
            }
        }
        if (!pack.getAuthor().isEmpty()) {
            for (List textList : Lists.partition(pack.getAuthor(), (int)2)) {
                AbstractModelGui.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TextComponent(textList.toString()).m_130940_(ChatFormatting.GOLD), (int)sideMiddleX, (int)(middleY + (offsetY += 10)), (int)0xFFFFFF);
            }
        }
        if (pack.getVersion() != null) {
            AbstractModelGui.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TranslatableComponent("gui.touhou_little_maid.skin.text.version", new Object[]{pack.getVersion()}).m_130940_(ChatFormatting.DARK_AQUA), (int)sideMiddleX, (int)(middleY + (offsetY += 10)), (int)0xFFFFFF);
        }
        if (pack.getDate() != null) {
            AbstractModelGui.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TranslatableComponent("gui.touhou_little_maid.skin.text.date", new Object[]{pack.getDate()}).m_130940_(ChatFormatting.GREEN), (int)sideMiddleX, (int)(middleY + (offsetY += 10)), (int)0xFFFFFF);
        }
        AbstractModelGui.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)String.format("%s/%s", this.getPageIndex() + 1, this.guiNumber.getPageSize()), (int)middleX, (int)(middleY - 120), (int)0xFFFFFF);
    }

    private void drawTooltips(PoseStack poseStack, int mouseX, int mouseY, int middleX, int middleY) {
        boolean yInRange;
        boolean isyInRange;
        boolean isxInRange;
        CustomModelPack<E> pack = this.modelPackList.get(this.getPackIndex());
        int offsetX = -100;
        int offsetY = -35;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        int toIndex = this.guiNumber.modelToIndex(this.getPackIndex(), this.getRowIndex());
        for (IModelInfo modelItem : pack.getModelList().subList(fromIndex, toIndex)) {
            isxInRange = middleX + offsetX - 8 < mouseX && mouseX < middleX + offsetX + 7;
            boolean bl = isyInRange = middleY + offsetY - 23 < mouseY && mouseY < middleY + offsetY + 1;
            if (isxInRange && isyInRange) {
                ArrayList<String> str = new ArrayList<String>();
                str.add(modelItem.getName());
                str.addAll(modelItem.getDescription());
                List<Component> tooltips = ParseI18n.parse(str);
                if (!modelItem.getName().equals("{gui.touhou_little_maid.model_gui.easter_egg.encrypt}") && !modelItem.getName().equals("{gui.touhou_little_maid.model_gui.easter_egg.normal}")) {
                    tooltips.add((Component)new TranslatableComponent("gui.touhou_little_maid.skin.tooltips.show_details").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                }
                this.m_96597_(poseStack, tooltips, mouseX, mouseY);
            }
            if ((offsetX += 20) <= 105) continue;
            offsetX = -100;
            offsetY += 30;
        }
        int size = this.guiNumber.getTabSize(this.getPackIndex());
        for (int index = 0; index < size; ++index) {
            isxInRange = middleX - 98 + 28 * index < mouseX && mouseX < middleX - 98 + 28 * index + 28;
            boolean bl = isyInRange = middleY - 108 < mouseY && mouseY < middleY - 108 + 31;
            if (!isxInRange || !isyInRange) continue;
            CustomModelPack<E> hoverPack = this.modelPackList.get(this.guiNumber.tabToPackIndex(index, this.getPageIndex()));
            this.m_96602_(poseStack, (Component)ParseI18n.parse(hoverPack.getPackName()), mouseX, mouseY);
        }
        boolean xInRange = middleX + 122 < mouseX && mouseX < middleX + 143;
        boolean bl = yInRange = middleY - 97 < mouseY && mouseY < middleY - 80;
        if (xInRange && yInRange) {
            this.m_96602_(poseStack, (Component)new TranslatableComponent("gui.touhou_little_maid.skin.button.close"), mouseX, mouseY);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta != 0.0) {
            int row;
            int index = 0;
            if (delta > 0.0) {
                index = 1;
            }
            if (delta < 0.0) {
                index = -1;
            }
            if ((row = Mth.m_14045_((int)(this.getRowIndex() - index), (int)0, (int)this.guiNumber.getRowSize(this.getPackIndex()))) != this.getRowIndex()) {
                this.setRowIndex(row);
                this.m_7856_();
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7043_() {
        return false;
    }
}

