/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.model.EntityBoxModel;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBox;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class EntityBoxRender
extends EntityRenderer<EntityBox> {
    private final List<ResourceLocation> texturesGroup = Lists.newArrayList();
    private final EntityModel<EntityBox> boxModel;

    public EntityBoxRender(EntityRendererProvider.Context manager) {
        super(manager);
        this.boxModel = new EntityBoxModel(manager.m_174023_(EntityBoxModel.LAYER));
        IntStream.range(0, 7).forEach(this::addBoxTexture);
    }

    public void render(EntityBox entityBox, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_85837_(0.0, -1.501, 0.0);
        this.boxModel.m_6973_((Entity)entityBox, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        RenderType renderType = RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entityBox));
        VertexConsumer buffer = bufferIn.m_6299_(renderType);
        this.boxModel.m_7695_(poseStack, buffer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(EntityBox entity) {
        return this.texturesGroup.get(entity.getTextureIndex());
    }

    private void addBoxTexture(int index) {
        String fileName = String.format("textures/entity/box/cake_box_%s.png", index);
        this.texturesGroup.add(new ResourceLocation("touhou_little_maid", fileName));
    }
}

