/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.api.event.client.RenderMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.GlWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.ChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidBackItem;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidBipedHead;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidHeldItem;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.models.MaidModels;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.InGameMaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class EntityMaidRenderer
extends MobRenderer<EntityMaid, BedrockModel<EntityMaid>> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/empty.png");
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:hakurei_reimu";
    private MaidModelInfo mainInfo;
    private List<Object> mainAnimations = Lists.newArrayList();

    public EntityMaidRenderer(EntityRendererProvider.Context manager) {
        super(manager, new BedrockModel(), 0.5f);
        this.m_115326_(new LayerMaidHeldItem(this));
        this.m_115326_(new LayerMaidBipedHead(this, manager.m_174027_()));
        this.m_115326_(new LayerMaidBackpack(this, manager.m_174027_()));
        this.m_115326_(new LayerMaidBackItem(this));
    }

    public void render(EntityMaid entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        this.renderHomeTips(entity, poseStack, bufferIn, packedLightIn);
        CustomPackLoader.MAID_MODELS.getModel(DEFAULT_MODEL_ID).ifPresent(model -> {
            this.f_115290_ = model;
        });
        CustomPackLoader.MAID_MODELS.getInfo(DEFAULT_MODEL_ID).ifPresent(info -> {
            this.mainInfo = info;
        });
        CustomPackLoader.MAID_MODELS.getAnimation(DEFAULT_MODEL_ID).ifPresent(animations -> {
            this.mainAnimations = animations;
        });
        MaidModels.ModelData eventModelData = new MaidModels.ModelData((BedrockModel)this.f_115290_, this.mainInfo, this.mainAnimations);
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderMaidEvent(entity, eventModelData))) {
            this.f_115290_ = eventModelData.getModel();
            this.mainInfo = eventModelData.getInfo();
            this.mainAnimations = eventModelData.getAnimations();
        } else {
            CustomPackLoader.MAID_MODELS.getModel(entity.getModelId()).ifPresent(model -> {
                this.f_115290_ = model;
            });
            CustomPackLoader.MAID_MODELS.getInfo(entity.getModelId()).ifPresent(info -> {
                this.mainInfo = info;
            });
            CustomPackLoader.MAID_MODELS.getAnimation(entity.getModelId()).ifPresent(animations -> {
                this.mainAnimations = animations;
            });
        }
        ((BedrockModel)this.f_115290_).setAnimations(this.mainAnimations);
        if (InGameMaidConfig.INSTANCE.isShowChatBubble()) {
            ChatBubbleRenderer.renderChatBubble(this, entity, poseStack, bufferIn, packedLightIn);
        }
        GlWrapper.setPoseStack(poseStack);
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        GlWrapper.clearPoseStack();
    }

    private void renderHomeTips(EntityMaid entity, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (entity.m_21536_() && player != null && this.extraCondition(entity, mc, (Player)player)) {
            BlockPos restrictCenter = entity.m_21534_();
            Vector3f home = new Vector3f((float)restrictCenter.m_123341_(), (float)restrictCenter.m_123342_(), (float)restrictCenter.m_123343_());
            home.m_122272_(0.5f, 0.25f, 0.5f);
            home.m_122272_((float)(-entity.m_20185_()), (float)(-entity.m_20186_()), (float)(-entity.m_20189_()));
            poseStack.m_85836_();
            poseStack.m_85837_((double)home.m_122239_(), (double)home.m_122260_() + 0.25, (double)home.m_122269_());
            poseStack.m_85845_(this.f_114476_.m_114470_());
            poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
            Matrix4f pose = poseStack.m_85850_().m_85861_();
            Font fontrenderer = this.m_114481_();
            String text = String.format("[%d, %d, %d]", restrictCenter.m_123341_(), restrictCenter.m_123342_(), restrictCenter.m_123343_());
            float x = -fontrenderer.m_92895_(text) / 2;
            fontrenderer.m_92811_(text, x, 0.0f, -1, false, pose, bufferIn, false, 0, packedLightIn);
            poseStack.m_85849_();
            VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110504_());
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            buffer.m_85982_(matrix4f, 0.0f, 0.5f, 0.0f).m_6122_(255, 0, 0, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix4f, home.m_122239_(), home.m_122260_(), home.m_122269_()).m_6122_(255, 0, 0, 255).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        }
    }

    private boolean extraCondition(EntityMaid entity, Minecraft mc, Player player) {
        if (player.m_21205_().m_41720_() == Items.f_42522_) {
            return entity.equals(mc.f_91076_) || player.m_6144_();
        }
        return false;
    }

    protected void scale(EntityMaid maid, PoseStack poseStack, float partialTickTime) {
        float scale = this.mainInfo.getRenderEntityScale();
        poseStack.m_85841_(scale, scale, scale);
    }

    public ResourceLocation getTextureLocation(EntityMaid maid) {
        if (this.mainInfo == null) {
            return DEFAULT_TEXTURE;
        }
        return this.mainInfo.getTexture();
    }

    public MaidModelInfo getMainInfo() {
        return this.mainInfo;
    }

    public EntityRenderDispatcher getDispatcher() {
        return this.f_114476_;
    }
}

