/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer;

import com.github.tartaricacid.touhoulittlemaid.client.model.MaidBackpackBigModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.MaidBackpackMiddleModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.MaidBackpackSmallModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockPart;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.config.InGameMaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class LayerMaidBackpack
extends RenderLayer<EntityMaid, BedrockModel<EntityMaid>> {
    private static final ResourceLocation SMALL = new ResourceLocation("touhou_little_maid", "textures/entity/maid_backpack_small.png");
    private static final ResourceLocation MIDDLE = new ResourceLocation("touhou_little_maid", "textures/entity/maid_backpack_middle.png");
    private static final ResourceLocation BIG = new ResourceLocation("touhou_little_maid", "textures/entity/maid_backpack_big.png");
    private final EntityMaidRenderer renderer;
    private final EntityModel<EntityMaid> smallModel;
    private final EntityModel<EntityMaid> middleModel;
    private final EntityModel<EntityMaid> bigModel;

    public LayerMaidBackpack(EntityMaidRenderer renderer, EntityModelSet modelSet) {
        super((RenderLayerParent)renderer);
        this.renderer = renderer;
        this.smallModel = new MaidBackpackSmallModel(modelSet.m_171103_(MaidBackpackSmallModel.LAYER));
        this.middleModel = new MaidBackpackMiddleModel(modelSet.m_171103_(MaidBackpackMiddleModel.LAYER));
        this.bigModel = new MaidBackpackBigModel(modelSet.m_171103_(MaidBackpackBigModel.LAYER));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, EntityMaid maid, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!this.renderer.getMainInfo().isShowBackpack() || !InGameMaidConfig.INSTANCE.isShowBackpack() || maid.m_5803_() || maid.m_20145_()) {
            return;
        }
        poseStack.m_85841_(1.01f, 1.01f, 1.01f);
        if (((BedrockModel)this.m_117386_()).hasBackpackPositioningModel()) {
            BedrockPart renderer = ((BedrockModel)this.m_117386_()).getBackpackPositioningModel();
            poseStack.m_85837_((double)renderer.x * 0.0625, 0.0625 * (double)(renderer.y - 23.0f + 8.0f), 0.0625 * (double)(renderer.z + 4.0f));
        } else {
            poseStack.m_85837_(0.0, -0.5, 0.25);
        }
        switch (maid.getBackpackLevel()) {
            case 1: {
                LayerMaidBackpack.m_117376_(this.smallModel, (ResourceLocation)SMALL, (PoseStack)poseStack, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)maid, (float)1.0f, (float)1.0f, (float)1.0f);
                return;
            }
            case 2: {
                LayerMaidBackpack.m_117376_(this.middleModel, (ResourceLocation)MIDDLE, (PoseStack)poseStack, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)maid, (float)1.0f, (float)1.0f, (float)1.0f);
                return;
            }
            case 3: {
                LayerMaidBackpack.m_117376_(this.bigModel, (ResourceLocation)BIG, (PoseStack)poseStack, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)maid, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

