/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer;

import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class LayerMaidHeldItem
extends RenderLayer<EntityMaid, BedrockModel<EntityMaid>> {
    public LayerMaidHeldItem(EntityMaidRenderer maidRenderer) {
        super((RenderLayerParent)maidRenderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, EntityMaid maid, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack mainRightItem = maid.m_21205_();
        ItemStack offLeftItem = maid.m_21206_();
        BedrockModel model = (BedrockModel)this.m_117386_();
        if (!mainRightItem.m_41619_() && model.hasRightArm()) {
            this.renderArmWithItem(maid, mainRightItem, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, poseStack, bufferIn, packedLightIn);
        }
        if (!offLeftItem.m_41619_() && model.hasLeftArm()) {
            this.renderArmWithItem(maid, offLeftItem, ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, poseStack, bufferIn, packedLightIn);
        }
    }

    private void renderArmWithItem(EntityMaid maid, ItemStack itemStack, ItemTransforms.TransformType transformTypeIn, HumanoidArm handSide, PoseStack poseStack, MultiBufferSource typeBuffer, int combinedLightIn) {
        if (!itemStack.m_41619_()) {
            poseStack.m_85836_();
            boolean isLeft = handSide == HumanoidArm.LEFT;
            ((BedrockModel)this.m_117386_()).translateToHand(handSide, poseStack);
            if (((BedrockModel)this.m_117386_()).hasArmPositioningModel(handSide)) {
                ((BedrockModel)this.m_117386_()).translateToPositioningHand(handSide, poseStack);
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                poseStack.m_85837_(0.0, 0.125, -0.0625);
            } else {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                poseStack.m_85837_((double)(isLeft ? -1 : 1) / 16.0, 0.125, -0.525);
            }
            Minecraft.m_91087_().m_91292_().m_109322_((LivingEntity)maid, itemStack, transformTypeIn, isLeft, poseStack, typeBuffer, combinedLightIn);
            poseStack.m_85849_();
        }
    }
}

