/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.client.model.StatueBaseModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.ItemGarageKit;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TileEntityItemStackGarageKitRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/statue_base.png");
    private static StatueBaseModel BASE_MODEL;

    public TileEntityItemStackGarageKitRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
        BASE_MODEL = new StatueBaseModel(modelSet.m_171103_(StatueBaseModel.LAYER));
    }

    public void m_108829_(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_85837_(1.0, 0.5, 1.0);
        poseStack.m_85845_(Vector3f.f_122226_.m_122240_(180.0f));
        VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE));
        BASE_MODEL.m_7695_(poseStack, buffer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        CompoundTag data = ItemGarageKit.getMaidData(stack);
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (data.m_128456_() || world == null) {
            return;
        }
        EntityType.m_20632_((String)data.m_128461_("id")).ifPresent(arg_0 -> this.lambda$renderByItem$0(poseStack, bufferIn, combinedLightIn, data, (Level)world, arg_0));
    }

    private void renderEntity(PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, CompoundTag data, Level world, EntityType<?> type) throws ExecutionException {
        Entity entity = (Entity)EntityCacheUtil.ENTITY_CACHE.get(type, () -> {
            Entity e = type.m_20615_(world);
            return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
        });
        float renderItemScale = 1.0f;
        entity.m_20258_(data);
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            EntityCacheUtil.clearMaidDataResidue(maid, true);
            if (data.m_128425_("ModelId", 8)) {
                String modelId = data.m_128461_("ModelId");
                renderItemScale = CustomPackLoader.MAID_MODELS.getModelRenderItemScale(modelId);
            }
        }
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_85841_(renderItemScale, renderItemScale, renderItemScale);
        poseStack.m_85837_(1.0, 0.21328125, 1.0);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        EntityRenderDispatcher render = Minecraft.m_91087_().m_91290_();
        boolean isShowHitBox = render.m_114377_();
        render.m_114473_(false);
        RenderSystem.m_69890_(() -> render.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, bufferIn, combinedLightIn));
        render.m_114473_(isShowHitBox);
        poseStack.m_85849_();
    }

    private /* synthetic */ void lambda$renderByItem$0(PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, CompoundTag data, Level world, EntityType type) {
        try {
            this.renderEntity(poseStack, bufferIn, combinedLightIn, data, world, type);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }
}

