/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.CustomJsAnimationManger;
import com.github.tartaricacid.touhoulittlemaid.client.model.BedrockVersion;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.BedrockModelPOJO;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.CubesItem;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.FilePackTexture;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.ZipPackTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.models.ChairModels;
import com.github.tartaricacid.touhoulittlemaid.client.resource.models.MaidModels;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.ChatBubbleInfo;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.InGameMaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatText;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.GetJarResources;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.locale.Language;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@OnlyIn(value=Dist.CLIENT)
public class CustomPackLoader {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(CubesItem.class, (Object)new CubesItem.Deserializer()).registerTypeAdapter(ChatText.class, (Object)new ChatText.Serializer()).create();
    public static final MaidModels MAID_MODELS = MaidModels.getInstance();
    public static final ChairModels CHAIR_MODELS = ChairModels.getInstance();
    private static final Set<ResourceLocation> TMP_REGISTER_TEXTURE = Sets.newHashSet();
    private static final String COMMENT_SYMBOL = "#";
    private static final String CUSTOM_PACK_DIR_NAME = "tlm_custom_pack";
    public static final Path PACK_FOLDER = Paths.get(Minecraft.m_91087_().f_91069_.toURI()).resolve("tlm_custom_pack");
    private static final String DEFAULT_PACK_NAME = "touhou_little_maid-1.0.0.zip";
    private static final Marker MARKER = MarkerManager.getMarker((String)"CustomPackLoader");
    private static final Pattern DOMAIN = Pattern.compile("^assets/([\\w.]+)/$");

    public static void reloadPacks() {
        CustomJsAnimationManger.clearAll();
        MAID_MODELS.clearAll();
        CHAIR_MODELS.clearAll();
        TMP_REGISTER_TEXTURE.clear();
        CustomPackLoader.initPacks();
        InGameMaidConfig.read();
    }

    private static void initPacks() {
        File packFolder = PACK_FOLDER.toFile();
        if (!packFolder.isDirectory()) {
            try {
                Files.createDirectories(packFolder.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        CustomPackLoader.checkDefaultPack();
        CustomPackLoader.loadPacks(packFolder);
    }

    private static void checkDefaultPack() {
        String jarDefaultPackPath = String.format("/assets/%s/%s/%s", "touhou_little_maid", CUSTOM_PACK_DIR_NAME, DEFAULT_PACK_NAME);
        GetJarResources.copyTouhouLittleMaidFile(jarDefaultPackPath, PACK_FOLDER, DEFAULT_PACK_NAME);
    }

    private static void loadPacks(File packFolder) {
        File[] files = packFolder.listFiles((dir, name) -> true);
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isFile() && file.getName().endsWith(".zip")) {
                CustomPackLoader.readModelFromZipFile(file);
            }
            if (!file.isDirectory()) continue;
            CustomPackLoader.readModelFromFolder(file);
        }
    }

    public static void readModelFromFolder(File root) {
        try {
            File[] domainFiles = root.toPath().resolve("assets").toFile().listFiles((dir, name) -> true);
            if (domainFiles == null) {
                return;
            }
            for (File domainDir : domainFiles) {
                if (!domainDir.isDirectory()) continue;
                Path rootPath = root.toPath();
                String domain = domainDir.getName();
                CustomPackLoader.loadMaidModelPack(rootPath, domain);
                CustomPackLoader.loadChairModelPack(rootPath, domain);
                CustomPackLoader.readLanguageFile(rootPath, domain);
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    public static void readModelFromZipFile(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> iteration = zipFile.entries();
            while (iteration.hasMoreElements()) {
                Matcher matcher = DOMAIN.matcher(iteration.nextElement().getName());
                if (!matcher.find()) continue;
                String domain = matcher.group(1);
                CustomPackLoader.loadMaidModelPack(zipFile, domain);
                CustomPackLoader.loadChairModelPack(zipFile, domain);
                CustomPackLoader.readLanguageFile(zipFile, domain);
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    private static void loadMaidModelPack(Path rootPath, String domain) {
        TouhouLittleMaid.LOGGER.debug(MARKER, "Touhou little maid mod's model is loading...");
        File file = rootPath.resolve("assets").resolve(domain).resolve(MAID_MODELS.getJsonFileName()).toFile();
        if (!file.isFile()) {
            return;
        }
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            CustomModelPack pack = (CustomModelPack)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), new TypeToken<CustomModelPack<MaidModelInfo>>(){}.getType());
            pack.decorate();
            if (pack.getIcon() != null) {
                CustomPackLoader.registerFilePackTexture(rootPath, pack.getIcon());
            }
            for (MaidModelInfo maidModelItem : pack.getModelList()) {
                BedrockModel<EntityMaid> modelJson = CustomPackLoader.loadMaidModel(rootPath, maidModelItem.getModel());
                CustomPackLoader.registerFilePackTexture(rootPath, maidModelItem.getTexture());
                ChatBubbleInfo chatBubble = maidModelItem.getChatBubble();
                CustomPackLoader.registerFilePackTexture(rootPath, chatBubble.getBg());
                ChatBubbleInfo.Text text = chatBubble.getText();
                text.getMain().values().forEach(chatTexts -> chatTexts.stream().filter(ChatText::isIcon).forEach(chatText -> CustomPackLoader.registerFilePackTexture(rootPath, chatText.getIconPath())));
                text.getSpecial().values().forEach(chatTexts -> chatTexts.stream().filter(ChatText::isIcon).forEach(chatText -> CustomPackLoader.registerFilePackTexture(rootPath, chatText.getIconPath())));
                text.getOther().values().forEach(chatTexts -> chatTexts.stream().filter(ChatText::isIcon).forEach(chatText -> CustomPackLoader.registerFilePackTexture(rootPath, chatText.getIconPath())));
                List<Object> animations = CustomJsAnimationManger.getCustomAnimation(rootPath, (IModelInfo)maidModelItem);
                if (modelJson == null) continue;
                if (maidModelItem.getEasterEgg() != null && StringUtils.isNotBlank((CharSequence)maidModelItem.getEasterEgg().getTag())) {
                    CustomPackLoader.putMaidEasterEggData(maidModelItem, modelJson, animations);
                } else {
                    CustomPackLoader.putMaidModelData(maidModelItem, modelJson, animations);
                }
                TouhouLittleMaid.LOGGER.debug(MARKER, "Loaded model: {}", (Object)maidModelItem.getModel());
            }
            MAID_MODELS.addPack(pack);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Fail to parse model pack in domain {}", (Object)domain);
            e.printStackTrace();
        }
        TouhouLittleMaid.LOGGER.debug(MARKER, "Touhou little maid mod's model is loaded");
    }

    private static void loadMaidModelPack(ZipFile zipFile, String domain) {
        TouhouLittleMaid.LOGGER.debug(MARKER, "Touhou little maid mod's model is loading...");
        ZipEntry entry = zipFile.getEntry(String.format("assets/%s/%s", domain, MAID_MODELS.getJsonFileName()));
        if (entry == null) {
            return;
        }
        try (InputStream stream = zipFile.getInputStream(entry);){
            CustomModelPack pack = (CustomModelPack)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), new TypeToken<CustomModelPack<MaidModelInfo>>(){}.getType());
            pack.decorate();
            if (pack.getIcon() != null) {
                CustomPackLoader.registerZipPackTexture(zipFile.getName(), pack.getIcon());
            }
            for (MaidModelInfo maidModelItem : pack.getModelList()) {
                BedrockModel<EntityMaid> modelJson = CustomPackLoader.loadMaidModel(zipFile, maidModelItem.getModel());
                CustomPackLoader.registerZipPackTexture(zipFile.getName(), maidModelItem.getTexture());
                ChatBubbleInfo chatBubble = maidModelItem.getChatBubble();
                CustomPackLoader.registerZipPackTexture(zipFile.getName(), chatBubble.getBg());
                ChatBubbleInfo.Text text = chatBubble.getText();
                text.getMain().values().forEach(chatTexts -> chatTexts.stream().filter(ChatText::isIcon).forEach(chatText -> CustomPackLoader.registerZipPackTexture(zipFile.getName(), chatText.getIconPath())));
                text.getSpecial().values().forEach(chatTexts -> chatTexts.stream().filter(ChatText::isIcon).forEach(chatText -> CustomPackLoader.registerZipPackTexture(zipFile.getName(), chatText.getIconPath())));
                text.getOther().values().forEach(chatTexts -> chatTexts.stream().filter(ChatText::isIcon).forEach(chatText -> CustomPackLoader.registerZipPackTexture(zipFile.getName(), chatText.getIconPath())));
                List<Object> animations = CustomJsAnimationManger.getCustomAnimation(zipFile, (IModelInfo)maidModelItem);
                if (modelJson == null) continue;
                if (maidModelItem.getEasterEgg() != null && StringUtils.isNotBlank((CharSequence)maidModelItem.getEasterEgg().getTag())) {
                    CustomPackLoader.putMaidEasterEggData(maidModelItem, modelJson, animations);
                } else {
                    CustomPackLoader.putMaidModelData(maidModelItem, modelJson, animations);
                }
                TouhouLittleMaid.LOGGER.debug(MARKER, "Loaded model: {}", (Object)maidModelItem.getModel());
            }
            MAID_MODELS.addPack(pack);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Fail to parse model pack in domain {}", (Object)domain);
            e.printStackTrace();
        }
        TouhouLittleMaid.LOGGER.debug(MARKER, "Touhou little maid mod's model is loaded");
    }

    private static void putMaidEasterEggData(MaidModelInfo maidModelItem, BedrockModel<EntityMaid> modelJson, List<Object> animations) {
        MaidModelInfo.EasterEgg easterEgg = maidModelItem.getEasterEgg();
        MaidModels.ModelData data = new MaidModels.ModelData(modelJson, maidModelItem, animations);
        if (easterEgg.isEncrypt()) {
            MAID_MODELS.putEasterEggEncryptTagModel(easterEgg.getTag(), data);
        } else {
            MAID_MODELS.putEasterEggNormalTagModel(easterEgg.getTag(), data);
        }
    }

    private static void putMaidModelData(MaidModelInfo maidModelItem, BedrockModel<EntityMaid> modelJson, List<Object> animations) {
        String id = maidModelItem.getModelId().toString();
        MAID_MODELS.putModel(id, modelJson);
        MAID_MODELS.putInfo(id, maidModelItem);
        if (animations != null && animations.size() > 0) {
            MAID_MODELS.putAnimation(id, animations);
        }
    }

    private static void loadChairModelPack(Path rootPath, String domain) {
        TouhouLittleMaid.LOGGER.debug(MARKER, "Touhou little maid mod's model is loading...");
        File file = rootPath.resolve("assets").resolve(domain).resolve(CHAIR_MODELS.getJsonFileName()).toFile();
        if (!file.isFile()) {
            return;
        }
        try (InputStream stream2 = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            CustomModelPack pack = (CustomModelPack)GSON.fromJson((Reader)new InputStreamReader(stream2, StandardCharsets.UTF_8), new TypeToken<CustomModelPack<ChairModelInfo>>(){}.getType());
            pack.decorate();
            if (pack.getIcon() != null) {
                CustomPackLoader.registerFilePackTexture(rootPath, pack.getIcon());
            }
            for (ChairModelInfo chairModelItem : pack.getModelList()) {
                BedrockModel<EntityChair> modelJson = CustomPackLoader.loadChairModel(rootPath, chairModelItem.getModel());
                CustomPackLoader.registerFilePackTexture(rootPath, chairModelItem.getTexture());
                List<Object> animations = CustomJsAnimationManger.getCustomAnimation(rootPath, (IModelInfo)chairModelItem);
                if (modelJson == null) continue;
                String id = chairModelItem.getModelId().toString();
                CHAIR_MODELS.putModel(id, modelJson);
                CHAIR_MODELS.putInfo(id, chairModelItem);
                if (animations != null && animations.size() > 0) {
                    CHAIR_MODELS.putAnimation(id, animations);
                }
                TouhouLittleMaid.LOGGER.debug(MARKER, "Loaded model: {}", (Object)chairModelItem.getModel());
            }
            CHAIR_MODELS.addPack(pack);
        }
        catch (IOException stream2) {
        }
        catch (JsonSyntaxException e) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Fail to parse model pack in domain {}", (Object)domain);
            e.printStackTrace();
        }
        TouhouLittleMaid.LOGGER.debug(MARKER, "Touhou little maid mod's model is loaded");
    }

    private static void loadChairModelPack(ZipFile zipFile, String domain) {
        TouhouLittleMaid.LOGGER.debug(MARKER, "Touhou little maid mod's model is loading...");
        ZipEntry entry = zipFile.getEntry(String.format("assets/%s/%s", domain, CHAIR_MODELS.getJsonFileName()));
        if (entry == null) {
            return;
        }
        try (InputStream stream2 = zipFile.getInputStream(entry);){
            CustomModelPack pack = (CustomModelPack)GSON.fromJson((Reader)new InputStreamReader(stream2, StandardCharsets.UTF_8), new TypeToken<CustomModelPack<ChairModelInfo>>(){}.getType());
            pack.decorate();
            if (pack.getIcon() != null) {
                CustomPackLoader.registerZipPackTexture(zipFile.getName(), pack.getIcon());
            }
            for (ChairModelInfo chairModelItem : pack.getModelList()) {
                BedrockModel<EntityChair> modelJson = CustomPackLoader.loadChairModel(zipFile, chairModelItem.getModel());
                CustomPackLoader.registerZipPackTexture(zipFile.getName(), chairModelItem.getTexture());
                List<Object> animations = CustomJsAnimationManger.getCustomAnimation(zipFile, (IModelInfo)chairModelItem);
                if (modelJson == null) continue;
                String id = chairModelItem.getModelId().toString();
                CHAIR_MODELS.putModel(id, modelJson);
                CHAIR_MODELS.putInfo(id, chairModelItem);
                if (animations != null && animations.size() > 0) {
                    CHAIR_MODELS.putAnimation(id, animations);
                }
                TouhouLittleMaid.LOGGER.debug(MARKER, "Loaded model: {}", (Object)chairModelItem.getModel());
            }
            CHAIR_MODELS.addPack(pack);
        }
        catch (IOException stream2) {
        }
        catch (JsonSyntaxException e) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Fail to parse model pack in domain {}", (Object)domain);
            e.printStackTrace();
        }
        TouhouLittleMaid.LOGGER.debug(MARKER, "Touhou little maid mod's model is loaded");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static BedrockModel<EntityMaid> loadMaidModel(Path rootPath, ResourceLocation modelLocation) {
        File file = rootPath.resolve("assets").resolve(modelLocation.m_135827_()).resolve(modelLocation.m_135815_()).toFile();
        if (!file.isFile()) {
            return null;
        }
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            BedrockModelPOJO pojo = (BedrockModelPOJO)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), BedrockModelPOJO.class);
            if (pojo.getFormatVersion().equals(BedrockVersion.LEGACY.getVersion())) {
                if (pojo.getGeometryModelLegacy() != null) {
                    BedrockModel<EntityMaid> bedrockModel = new BedrockModel<EntityMaid>(pojo, BedrockVersion.LEGACY);
                    return bedrockModel;
                }
                TouhouLittleMaid.LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
                BedrockModel<EntityMaid> bedrockModel = null;
                return bedrockModel;
            }
            if (pojo.getFormatVersion().equals(BedrockVersion.NEW.getVersion())) {
                if (pojo.getGeometryModelNew() != null) {
                    BedrockModel<EntityMaid> bedrockModel = new BedrockModel<EntityMaid>(pojo, BedrockVersion.NEW);
                    return bedrockModel;
                }
                TouhouLittleMaid.LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
                BedrockModel<EntityMaid> bedrockModel = null;
                return bedrockModel;
            }
            TouhouLittleMaid.LOGGER.warn(MARKER, "{} model version is not 1.10.0 or 1.12.0", (Object)modelLocation);
            return null;
        }
        catch (IOException ioe) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Failed to load model: {}", (Object)modelLocation);
            ioe.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static BedrockModel<EntityMaid> loadMaidModel(ZipFile zipFile, ResourceLocation modelLocation) {
        String path = String.format("assets/%s/%s", modelLocation.m_135827_(), modelLocation.m_135815_());
        ZipEntry entry = zipFile.getEntry(path);
        if (entry == null) {
            return null;
        }
        try (InputStream stream = zipFile.getInputStream(entry);){
            BedrockModelPOJO pojo = (BedrockModelPOJO)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), BedrockModelPOJO.class);
            if (pojo.getFormatVersion().equals(BedrockVersion.LEGACY.getVersion())) {
                if (pojo.getGeometryModelLegacy() != null) {
                    BedrockModel<EntityMaid> bedrockModel = new BedrockModel<EntityMaid>(pojo, BedrockVersion.LEGACY);
                    return bedrockModel;
                }
                TouhouLittleMaid.LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
                BedrockModel<EntityMaid> bedrockModel = null;
                return bedrockModel;
            }
            if (pojo.getFormatVersion().equals(BedrockVersion.NEW.getVersion())) {
                if (pojo.getGeometryModelNew() != null) {
                    BedrockModel<EntityMaid> bedrockModel = new BedrockModel<EntityMaid>(pojo, BedrockVersion.NEW);
                    return bedrockModel;
                }
                TouhouLittleMaid.LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
                BedrockModel<EntityMaid> bedrockModel = null;
                return bedrockModel;
            }
            TouhouLittleMaid.LOGGER.warn(MARKER, "{} model version is not 1.10.0 or 1.12.0", (Object)modelLocation);
            return null;
        }
        catch (IOException ioe) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Failed to load model: {}", (Object)modelLocation);
            ioe.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static BedrockModel<EntityChair> loadChairModel(Path rootPath, ResourceLocation modelLocation) {
        File file = rootPath.resolve("assets").resolve(modelLocation.m_135827_()).resolve(modelLocation.m_135815_()).toFile();
        if (!file.isFile()) {
            return null;
        }
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            BedrockModelPOJO pojo = (BedrockModelPOJO)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), BedrockModelPOJO.class);
            if (pojo.getFormatVersion().equals(BedrockVersion.LEGACY.getVersion())) {
                if (pojo.getGeometryModelLegacy() != null) {
                    BedrockModel<EntityChair> bedrockModel = new BedrockModel<EntityChair>(pojo, BedrockVersion.LEGACY);
                    return bedrockModel;
                }
                TouhouLittleMaid.LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
                BedrockModel<EntityChair> bedrockModel = null;
                return bedrockModel;
            }
            if (pojo.getFormatVersion().equals(BedrockVersion.NEW.getVersion())) {
                if (pojo.getGeometryModelNew() != null) {
                    BedrockModel<EntityChair> bedrockModel = new BedrockModel<EntityChair>(pojo, BedrockVersion.NEW);
                    return bedrockModel;
                }
                TouhouLittleMaid.LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
                BedrockModel<EntityChair> bedrockModel = null;
                return bedrockModel;
            }
            TouhouLittleMaid.LOGGER.warn(MARKER, "{} model version is not 1.10.0 or 1.12.0", (Object)modelLocation);
            return null;
        }
        catch (IOException ioe) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Failed to load model: {}", (Object)modelLocation);
            ioe.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static BedrockModel<EntityChair> loadChairModel(ZipFile zipFile, ResourceLocation modelLocation) {
        String path = String.format("assets/%s/%s", modelLocation.m_135827_(), modelLocation.m_135815_());
        ZipEntry entry = zipFile.getEntry(path);
        if (entry == null) {
            return null;
        }
        try (InputStream stream = zipFile.getInputStream(entry);){
            BedrockModelPOJO pojo = (BedrockModelPOJO)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), BedrockModelPOJO.class);
            if (pojo.getFormatVersion().equals(BedrockVersion.LEGACY.getVersion())) {
                if (pojo.getGeometryModelLegacy() != null) {
                    BedrockModel<EntityChair> bedrockModel = new BedrockModel<EntityChair>(pojo, BedrockVersion.LEGACY);
                    return bedrockModel;
                }
                TouhouLittleMaid.LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
                BedrockModel<EntityChair> bedrockModel = null;
                return bedrockModel;
            }
            if (pojo.getFormatVersion().equals(BedrockVersion.NEW.getVersion())) {
                if (pojo.getGeometryModelNew() != null) {
                    BedrockModel<EntityChair> bedrockModel = new BedrockModel<EntityChair>(pojo, BedrockVersion.NEW);
                    return bedrockModel;
                }
                TouhouLittleMaid.LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
                BedrockModel<EntityChair> bedrockModel = null;
                return bedrockModel;
            }
            TouhouLittleMaid.LOGGER.warn(MARKER, "{} model version is not 1.10.0 or 1.12.0", (Object)modelLocation);
            return null;
        }
        catch (IOException ioe) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Failed to load model: {}", (Object)modelLocation);
            ioe.printStackTrace();
        }
        return null;
    }

    private static void registerFilePackTexture(Path rootPath, ResourceLocation texturePath) {
        FilePackTexture filePackTexture;
        if (!TMP_REGISTER_TEXTURE.contains(texturePath) && (filePackTexture = new FilePackTexture(rootPath, texturePath)).isExist()) {
            Minecraft.m_91087_().f_90987_.m_118495_(texturePath, (AbstractTexture)filePackTexture);
            TMP_REGISTER_TEXTURE.add(texturePath);
        }
    }

    private static void registerZipPackTexture(String zipFilePath, ResourceLocation texturePath) {
        ZipPackTexture zipPackTexture;
        if (!TMP_REGISTER_TEXTURE.contains(texturePath) && (zipPackTexture = new ZipPackTexture(zipFilePath, texturePath)).isExist()) {
            Minecraft.m_91087_().f_90987_.m_118495_(texturePath, (AbstractTexture)zipPackTexture);
            TMP_REGISTER_TEXTURE.add(texturePath);
        }
    }

    private static void readLanguageFile(ZipFile zipFile, String namespace) throws IOException {
        LanguageInfo language = Minecraft.m_91087_().m_91102_().m_118983_();
        Map oldLangData = Language.m_128107_().getLanguageData();
        HashMap newLangData = Maps.newHashMap();
        String defaultLangPath = String.format("assets/%s/lang/en_us.lang", namespace);
        String currentLangPath = String.format("assets/%s/lang/%s.lang", namespace, language.getCode());
        CustomPackLoader.getLanguageMap(zipFile, (Map<String, String>)newLangData, defaultLangPath);
        CustomPackLoader.getLanguageMap(zipFile, (Map<String, String>)newLangData, currentLangPath);
        CustomPackLoader.languageMapMerge(oldLangData, newLangData);
        if (Language.m_128107_() instanceof ClientLanguage) {
            ((ClientLanguage)Language.m_128107_()).f_118910_ = newLangData;
        }
    }

    private static void readLanguageFile(Path rootPath, String namespace) throws IOException {
        LanguageInfo language = Minecraft.m_91087_().m_91102_().m_118983_();
        Map oldLangData = Language.m_128107_().getLanguageData();
        HashMap newLangData = Maps.newHashMap();
        String defaultLangPath = String.format("assets/%s/lang/en_us.lang", namespace);
        String currentLangPath = String.format("assets/%s/lang/%s.lang", namespace, language.getCode());
        CustomPackLoader.getLanguageMap(rootPath, (Map<String, String>)newLangData, defaultLangPath);
        CustomPackLoader.getLanguageMap(rootPath, (Map<String, String>)newLangData, currentLangPath);
        CustomPackLoader.languageMapMerge(oldLangData, newLangData);
        if (Language.m_128107_() instanceof ClientLanguage) {
            ((ClientLanguage)Language.m_128107_()).f_118910_ = newLangData;
        }
    }

    private static void getLanguageMap(Path rootPath, Map<String, String> langData, String defaultLangPath) throws IOException {
        File file = rootPath.resolve(defaultLangPath).toFile();
        if (!file.isFile()) {
            return;
        }
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            List lines = IOUtils.readLines((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            for (String s : lines) {
                String[] map;
                if (s.startsWith(COMMENT_SYMBOL) || (map = s.split("=", 2)).length != 2) continue;
                langData.put(map[0], map[1]);
            }
        }
    }

    private static void getLanguageMap(ZipFile zipFile, Map<String, String> langData, String defaultLangPath) throws IOException {
        ZipEntry entry = zipFile.getEntry(defaultLangPath);
        if (entry == null) {
            return;
        }
        try (InputStream stream = zipFile.getInputStream(entry);){
            List lines = IOUtils.readLines((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            for (String s : lines) {
                String[] map;
                if (s.startsWith(COMMENT_SYMBOL) || (map = s.split("=", 2)).length != 2) continue;
                langData.put(map[0], map[1]);
            }
        }
    }

    private static void languageMapMerge(Map<String, String> oldLangData, Map<String, String> newLangData) {
        for (String key : oldLangData.keySet()) {
            if (newLangData.containsKey(key)) continue;
            newLangData.put(key, oldLangData.get(key));
        }
    }
}

