/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource.models;

import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class MaidModels {
    private static final String JSON_FILE_NAME = "maid_model.json";
    private static MaidModels INSTANCE;
    private final List<CustomModelPack<MaidModelInfo>> packList = Lists.newArrayList();
    private final HashMap<String, BedrockModel<EntityMaid>> idModelMap = Maps.newHashMap();
    private final HashMap<String, MaidModelInfo> idInfoMap = Maps.newHashMap();
    private final HashMap<String, List<Object>> idAnimationMap = Maps.newHashMap();
    private final HashMap<String, ModelData> easterEggNormalTagModelMap = Maps.newHashMap();
    private final HashMap<String, ModelData> easterEggEncryptTagModelMap = Maps.newHashMap();

    private MaidModels() {
    }

    public static MaidModels getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MaidModels();
        }
        return INSTANCE;
    }

    public void clearAll() {
        this.packList.clear();
        this.idModelMap.clear();
        this.idInfoMap.clear();
        this.idAnimationMap.clear();
        this.easterEggNormalTagModelMap.clear();
        this.easterEggEncryptTagModelMap.clear();
    }

    public String getJsonFileName() {
        return JSON_FILE_NAME;
    }

    public List<CustomModelPack<MaidModelInfo>> getPackList() {
        return this.packList;
    }

    public Set<String> getModelIdSet() {
        return this.idInfoMap.keySet();
    }

    public void addPack(CustomModelPack<MaidModelInfo> pack) {
        this.packList.add(pack);
    }

    public void putModel(String modelId, BedrockModel<EntityMaid> modelJson) {
        this.idModelMap.put(modelId, modelJson);
    }

    public void putInfo(String modelId, MaidModelInfo maidModelItem) {
        this.idInfoMap.put(modelId, maidModelItem);
    }

    public void putAnimation(String modelId, List<Object> animationJs) {
        this.idAnimationMap.put(modelId, animationJs);
    }

    public Optional<BedrockModel<EntityMaid>> getModel(String modelId) {
        return Optional.ofNullable(this.idModelMap.get(modelId));
    }

    public float getModelRenderItemScale(String modelId) {
        if (this.idInfoMap.containsKey(modelId)) {
            return this.idInfoMap.get(modelId).getRenderItemScale();
        }
        return 1.0f;
    }

    public Optional<List<Object>> getAnimation(String modelId) {
        return Optional.ofNullable(this.idAnimationMap.get(modelId));
    }

    public void removeAnimation(String modelId) {
        this.idAnimationMap.remove(modelId);
    }

    public Optional<MaidModelInfo> getInfo(String modelId) {
        return Optional.ofNullable(this.idInfoMap.get(modelId));
    }

    public boolean containsInfo(String modelId) {
        return this.idInfoMap.containsKey(modelId);
    }

    public Optional<ModelData> getEasterEggNormalTagModel(String tag) {
        return Optional.ofNullable(this.easterEggNormalTagModelMap.get(tag));
    }

    public Optional<ModelData> getEasterEggEncryptTagModel(String tag) {
        return Optional.ofNullable(this.easterEggEncryptTagModelMap.get(tag));
    }

    public void putEasterEggNormalTagModel(String tag, ModelData data) {
        this.easterEggNormalTagModelMap.put(tag, data);
    }

    public void putEasterEggEncryptTagModel(String tag, ModelData data) {
        this.easterEggEncryptTagModelMap.put(tag, data);
    }

    public static class ModelData {
        private BedrockModel<EntityMaid> model;
        private MaidModelInfo info;
        private List<Object> animations;

        public ModelData(BedrockModel<EntityMaid> model, MaidModelInfo info, @Nullable List<Object> animations) {
            this.model = model;
            this.info = info;
            this.animations = animations;
        }

        public BedrockModel<EntityMaid> getModel() {
            return this.model;
        }

        public void setModel(BedrockModel<EntityMaid> model) {
            this.model = model;
        }

        public MaidModelInfo getInfo() {
            return this.info;
        }

        public void setInfo(MaidModelInfo info) {
            this.info = info;
        }

        @Nullable
        public List<Object> getAnimations() {
            return this.animations;
        }

        public void setAnimations(List<Object> animations) {
            this.animations = animations;
        }
    }
}

