/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource.pojo;

import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ChairModelInfo
implements IModelInfo {
    private static final float RENDER_ENTITY_SCALE_MIN = 0.2f;
    private static final float RENDER_ENTITY_SCALE_MAX = 2.0f;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="description")
    private List<String> description;
    @SerializedName(value="model")
    private ResourceLocation model;
    @SerializedName(value="texture")
    private ResourceLocation texture;
    @SerializedName(value="model_id")
    private ResourceLocation modelId;
    @SerializedName(value="render_item_scale")
    private float renderItemScale = 1.0f;
    @SerializedName(value="render_entity_scale")
    private float renderEntityScale = 1.0f;
    @SerializedName(value="animation")
    private List<ResourceLocation> animation;
    @SerializedName(value="mounted_height")
    private float mountedYOffset;
    @SerializedName(value="tameable_can_ride")
    private boolean tameableCanRide = true;
    @SerializedName(value="no_gravity")
    private boolean noGravity = false;

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public List<ResourceLocation> getAnimation() {
        return this.animation;
    }

    @Override
    public ResourceLocation getModelId() {
        return this.modelId;
    }

    @Override
    public ResourceLocation getModel() {
        return this.model;
    }

    public float getMountedYOffset() {
        return this.mountedYOffset;
    }

    public boolean isTameableCanRide() {
        return this.tameableCanRide;
    }

    @Override
    public float getRenderItemScale() {
        return this.renderItemScale;
    }

    public float getRenderEntityScale() {
        return this.renderEntityScale;
    }

    public boolean isNoGravity() {
        return this.noGravity;
    }

    public ChairModelInfo decorate() {
        if (this.description == null) {
            this.description = Collections.EMPTY_LIST;
        }
        if (this.modelId == null) {
            throw new JsonSyntaxException("Expected \"model_id\" in model");
        }
        if (this.model == null) {
            this.model = new ResourceLocation(this.modelId.m_135827_(), "models/entity/" + this.modelId.m_135815_() + ".json");
        }
        if (this.texture == null) {
            this.texture = new ResourceLocation(this.modelId.m_135827_(), "textures/entity/" + this.modelId.m_135815_() + ".png");
        }
        if (this.name == null) {
            this.name = String.format("{model.%s.%s.name}", this.modelId.m_135827_(), this.modelId.m_135815_());
        }
        this.renderEntityScale = Mth.m_14036_((float)this.renderEntityScale, (float)0.2f, (float)2.0f);
        this.mountedYOffset = (this.mountedYOffset - 3.0f) * 0.0625f;
        return this;
    }
}

