/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.config;

import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.FileUtils;

@OnlyIn(value=Dist.CLIENT)
public class InGameMaidConfig {
    private static final File CONFIG_FILE = Minecraft.m_91087_().f_91069_.toPath().resolve("config").resolve("touhou_little_maid").resolve("in_game_maid_config.json").toFile();
    public static InGameMaidConfig INSTANCE;
    @SerializedName(value="sound_frequency")
    private double soundFrequency = 1.0;
    @SerializedName(value="show_chat_bubble")
    private boolean showChatBubble = true;
    @SerializedName(value="show_backpack")
    private boolean showBackpack = true;

    public static void read() {
        if (CONFIG_FILE.isFile()) {
            try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(CONFIG_FILE.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                INSTANCE = (InGameMaidConfig)CustomPackLoader.GSON.fromJson((Reader)reader, InGameMaidConfig.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            INSTANCE = new InGameMaidConfig();
        }
    }

    public static void save() {
        try {
            FileUtils.write((File)CONFIG_FILE, (CharSequence)CustomPackLoader.GSON.toJson((Object)INSTANCE), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double getSoundFrequency() {
        return this.soundFrequency;
    }

    public void setSoundFrequency(double soundFrequency) {
        this.soundFrequency = soundFrequency;
    }

    public boolean isShowChatBubble() {
        return this.showChatBubble;
    }

    public void setShowChatBubble(boolean showChatBubble) {
        this.showChatBubble = showChatBubble;
    }

    public boolean isShowBackpack() {
        return this.showBackpack;
    }

    public void setShowBackpack(boolean showBackpack) {
        this.showBackpack = showBackpack;
    }
}

