/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.config.subconfig;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public final class MaidConfig {
    public static final String TAG_PREFIX = "#";
    public static ForgeConfigSpec.ConfigValue<String> MAID_TAMED_ITEM;
    public static ForgeConfigSpec.ConfigValue<String> MAID_TEMPTATION_ITEM;
    public static ForgeConfigSpec.ConfigValue<String> MAID_NTR_ITEM;
    public static ForgeConfigSpec.IntValue MAID_HOME_RANGE;
    public static ForgeConfigSpec.BooleanValue MAID_CHANGE_MODEL;
    public static ForgeConfigSpec.IntValue OWNER_MAX_MAID_NUM;
    public static ForgeConfigSpec.ConfigValue<List<String>> MAID_RANGED_ATTACK_IGNORE;

    public static void init(ForgeConfigSpec.Builder builder) {
        builder.push("maid");
        builder.comment(new String[]{"The item that can tamed maid", "Use the registered name of the item directly or write tag name with # as prefix"});
        MAID_TAMED_ITEM = builder.define("MaidTamedItem", (Object)"minecraft:cake");
        builder.comment(new String[]{"The item that can temptation maid", "Use the registered name of the item directly or write tag name with # as prefix"});
        MAID_TEMPTATION_ITEM = builder.define("MaidTemptationItem", (Object)"minecraft:cake");
        builder.comment(new String[]{"The item that can NTR maid", "Use the registered name of the item directly or write tag name with # as prefix"});
        MAID_NTR_ITEM = builder.define("MaidNtrItem", (Object)"minecraft:structure_void");
        builder.comment("The max range of maid home mode");
        MAID_HOME_RANGE = builder.defineInRange("MaidHomeRange", 8, 3, 64);
        builder.comment("Maid can switch models freely");
        MAID_CHANGE_MODEL = builder.define("MaidChangeModel", true);
        builder.comment("The maximum number of maids the player own");
        OWNER_MAX_MAID_NUM = builder.defineInRange("OwnerMaxMaidNum", Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
        builder.comment("The entity that the maid will not hurt when in ranged attack");
        MAID_RANGED_ATTACK_IGNORE = builder.define("MaidRangedAttackIgnore", (Object)Lists.newArrayList());
        builder.pop();
    }
}

