/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.crafting;

import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCraftingHelper;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;

public class AltarRecipeSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<AltarRecipe> {
    public AltarRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        EntityCraftingHelper.Output output = EntityCraftingHelper.getEntityData(GsonHelper.m_13930_((JsonObject)json, (String)"output"));
        float powerCost = GsonHelper.m_13915_((JsonObject)json, (String)"power");
        JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
        ArrayList inputs = Lists.newArrayList();
        for (JsonElement e : ingredients) {
            inputs.add(Ingredient.m_43917_((JsonElement)e));
        }
        return new AltarRecipe(recipeId, output.getType(), output.getData(), powerCost, output.getCopyInput(), output.getCopyTag(), inputs.toArray(new Ingredient[0]));
    }

    @Nullable
    public AltarRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Optional typeOptional = EntityType.m_20632_((String)buffer.m_130277_());
        if (typeOptional.isPresent()) {
            EntityType entityType = (EntityType)typeOptional.get();
            CompoundTag extraData = buffer.m_130260_();
            float powerCost = buffer.readFloat();
            Ingredient copyInput = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            String copyTag = buffer.m_130277_();
            Ingredient[] inputs = new Ingredient[buffer.m_130242_()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            }
            return new AltarRecipe(recipeId, entityType, extraData, powerCost, copyInput, copyTag, inputs);
        }
        throw new JsonParseException("Entity Type Tag Not Found");
    }

    public void toNetwork(FriendlyByteBuf buffer, AltarRecipe recipe) {
        ResourceLocation name = recipe.getEntityType().getRegistryName();
        if (name == null) {
            throw new JsonParseException("Entity Type Tag Not Found");
        }
        buffer.m_130070_(name.toString());
        buffer.m_130079_(recipe.getExtraData());
        buffer.writeFloat(recipe.getPowerCost());
        recipe.getCopyInput().m_43923_(buffer);
        if (StringUtils.isEmpty((CharSequence)recipe.getCopyTag())) {
            buffer.m_130070_("");
        } else {
            buffer.m_130070_(recipe.getCopyTag());
        }
        buffer.m_130130_(recipe.m_7527_().size());
        for (Ingredient input : recipe.m_7527_()) {
            input.m_43923_(buffer);
        }
    }
}

