/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.data;

import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.util.NBTToJson;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;

public class AltarRecipeProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final DataGenerator generator;
    private final List<AltarRecipe> recipes = Lists.newArrayList();

    public AltarRecipeProvider(DataGenerator generator) {
        this.generator = generator;
    }

    protected void registerRecipes() {
        Ingredient gunpowder = Ingredient.m_204132_((TagKey)Tags.Items.GUNPOWDER);
        Ingredient blazePowder = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42593_});
        Ingredient paper = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42516_});
        Ingredient stick = Ingredient.m_204132_((TagKey)Tags.Items.RODS_WOODEN);
        Ingredient obsidian = Ingredient.m_204132_((TagKey)Tags.Items.OBSIDIAN);
        Ingredient redstone = Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE);
        Ingredient dyeCyan = Ingredient.m_204132_((TagKey)Tags.Items.DYES_CYAN);
        Ingredient dyeOrange = Ingredient.m_204132_((TagKey)Tags.Items.DYES_ORANGE);
        Ingredient dyeRed = Ingredient.m_204132_((TagKey)Tags.Items.DYES_RED);
        Ingredient dyeBlue = Ingredient.m_204132_((TagKey)Tags.Items.DYES_BLUE);
        Ingredient dyeYellow = Ingredient.m_204132_((TagKey)Tags.Items.DYES_YELLOW);
        Ingredient dyeLime = Ingredient.m_204132_((TagKey)Tags.Items.DYES_LIME);
        Ingredient shield = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42740_});
        Ingredient sugar = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42501_});
        Ingredient feather = Ingredient.m_204132_((TagKey)Tags.Items.FEATHERS);
        Ingredient fishes = Ingredient.m_204132_((TagKey)ItemTags.f_13156_);
        Ingredient plankWood = Ingredient.m_204132_((TagKey)ItemTags.f_13168_);
        Ingredient ingotGold = Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD);
        Ingredient ingotIron = Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON);
        Ingredient clayBall = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42461_});
        Ingredient redWool = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50108_});
        Ingredient pinkWool = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50100_});
        Ingredient grayWool = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50101_});
        Ingredient anyWool = Ingredient.m_204132_((TagKey)ItemTags.f_13167_);
        Ingredient enderPearl = Ingredient.m_204132_((TagKey)Tags.Items.ENDER_PEARLS);
        Ingredient gemDiamond = Ingredient.m_204132_((TagKey)Tags.Items.GEMS_DIAMOND);
        Ingredient gemEmerald = Ingredient.m_204132_((TagKey)Tags.Items.GEMS_EMERALD);
        Ingredient gemLapis = Ingredient.m_204132_((TagKey)Tags.Items.GEMS_LAPIS);
        Ingredient coal = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_});
        Ingredient netherWart = Ingredient.m_204132_((TagKey)Tags.Items.CROPS_NETHER_WART);
        Ingredient quartzBlock = Ingredient.m_204132_((TagKey)Tags.Items.STORAGE_BLOCKS_QUARTZ);
        Ingredient film = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)InitItems.FILM.get()});
        Ingredient noteBlock = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41859_});
        Ingredient chestsWooden = Ingredient.m_204132_((TagKey)Tags.Items.CHESTS_WOODEN);
        Ingredient hopper = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42155_});
        CompoundTag extraData = new CompoundTag();
        ListTag passengerList = new ListTag();
        CompoundTag passenger = new CompoundTag();
        passenger.m_128359_("id", Objects.requireNonNull(((EntityType)InitEntities.MAID.get()).getRegistryName()).toString());
        passengerList.add((Object)passenger);
        extraData.m_128365_("Passengers", (Tag)passengerList);
        this.addEntityRecipes((EntityType)InitEntities.BOX.get(), extraData, 0.5f, gemDiamond, gemLapis, ingotGold, redstone, ingotIron, coal);
        this.addEntityRecipes("reborn_maid", (EntityType)InitEntities.MAID.get(), new CompoundTag(), 0.5f, film, "MaidInfo", film, gemLapis, ingotGold, redstone, ingotIron, coal);
        this.addEntityRecipes(EntityType.f_20465_, 0.2f, gunpowder, gunpowder, gunpowder, blazePowder, blazePowder, blazePowder);
        this.addItemRecipes(InitItems.HAKUREI_GOHEI, 0.15f, stick, stick, stick, paper, paper, paper);
        this.addItemRecipes(InitItems.ULTRAMARINE_ORB_ELIXIR, 0.3f, gemEmerald, enderPearl, dyeCyan, dyeCyan, dyeCyan, dyeCyan);
        this.addItemRecipes(InitItems.EXPLOSION_PROTECT_BAUBLE, netherWart, dyeOrange, obsidian, obsidian, obsidian, obsidian);
        this.addItemRecipes(InitItems.FIRE_PROTECT_BAUBLE, netherWart, dyeRed, blazePowder, blazePowder, blazePowder, blazePowder);
        this.addItemRecipes(InitItems.PROJECTILE_PROTECT_BAUBLE, netherWart, dyeBlue, shield, shield, shield, shield);
        this.addItemRecipes(InitItems.MAGIC_PROTECT_BAUBLE, netherWart, dyeCyan, sugar, sugar, sugar, sugar);
        this.addItemRecipes(InitItems.FALL_PROTECT_BAUBLE, netherWart, dyeYellow, feather, feather, feather, feather);
        this.addItemRecipes(InitItems.DROWN_PROTECT_BAUBLE, netherWart, dyeLime, fishes, fishes, fishes, fishes);
        this.addItemRecipes(InitItems.MAID_BACKPACK_SMALL, 0.1f, redWool, redWool, redWool, redWool, ingotIron, redWool);
        this.addItemRecipes(InitItems.MAID_BACKPACK_MIDDLE, pinkWool, pinkWool, pinkWool, pinkWool, ingotGold, pinkWool);
        this.addItemRecipes(InitItems.MAID_BACKPACK_BIG, 0.3f, grayWool, grayWool, grayWool, grayWool, gemDiamond, grayWool);
        this.addItemRecipes(InitItems.EXTINGUISHER, clayBall, clayBall, clayBall, clayBall, ingotIron, dyeRed);
        this.addItemRecipes(InitItems.MAID_BED, pinkWool, pinkWool, pinkWool, plankWood, plankWood, plankWood);
        this.addItemRecipes(InitItems.NIMBLE_FABRIC, enderPearl, enderPearl, enderPearl, anyWool, anyWool, anyWool);
        this.addItemRecipes(InitItems.MUTE_BAUBLE, anyWool, anyWool, anyWool, clayBall, clayBall, clayBall);
        this.addItemRecipes(InitItems.ITEM_MAGNET_BAUBLE, redstone, redstone, redstone, ingotIron, ingotIron, ingotIron);
        this.addItemRecipes(InitItems.CAMERA, quartzBlock, quartzBlock, quartzBlock, quartzBlock, obsidian, obsidian);
        this.addItemRecipes(InitItems.CHISEL, stick, stick, ingotIron, ingotIron, dyeYellow, dyeRed);
        this.addItemRecipes(InitItems.TRUMPET, ingotGold, ingotGold, ingotIron, ingotIron, ingotIron, noteBlock);
        this.addItemRecipes(InitItems.WIRELESS_IO, enderPearl, chestsWooden, hopper);
        this.addItemRecipes(InitItems.MAID_BEACON, plankWood, dyeRed, plankWood, obsidian, gemDiamond, obsidian);
    }

    public void m_6865_(HashCache cache) throws IOException {
        Path path = this.generator.m_123916_();
        this.recipes.clear();
        this.registerRecipes();
        for (AltarRecipe recipe : this.recipes) {
            JsonObject jsonObject = this.recipeToJson(recipe);
            Path savePath = path.resolve("data/" + recipe.m_6423_().m_135827_() + "/recipes/altar/" + recipe.m_6423_().m_135815_() + ".json");
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)jsonObject, (Path)savePath);
        }
    }

    public void addRecipes(AltarRecipe recipe) {
        this.recipes.add(recipe);
    }

    public void addEntityRecipes(String name, EntityType<?> entityType, @Nullable CompoundTag extraData, float powerCost, Ingredient copyInput, @Nullable String copyTag, Ingredient ... inputs) {
        this.addRecipes(new AltarRecipe(new ResourceLocation("touhou_little_maid", name), entityType, extraData, powerCost, copyInput, copyTag, inputs));
    }

    public void addEntityRecipes(String name, EntityType<?> entityType, @Nullable CompoundTag extraData, float powerCost, Ingredient ... inputs) {
        this.addRecipes(new AltarRecipe(new ResourceLocation("touhou_little_maid", name), entityType, extraData, powerCost, inputs));
    }

    public void addEntityRecipes(EntityType<?> entityType, @Nullable CompoundTag extraData, float powerCost, Ingredient ... inputs) {
        ResourceLocation registryName = entityType.getRegistryName();
        if (registryName != null) {
            this.addEntityRecipes("spawn_" + registryName.m_135815_(), entityType, extraData, powerCost, inputs);
        }
    }

    public void addEntityRecipes(EntityType<?> entityType, float powerCost, Ingredient ... inputs) {
        this.addEntityRecipes(entityType, null, powerCost, inputs);
    }

    public void addItemRecipes(String name, ItemStack output, float powerCost, Ingredient ... inputs) {
        CompoundTag extraData = new CompoundTag();
        extraData.m_128365_("Item", (Tag)output.serializeNBT());
        this.addEntityRecipes(name, EntityType.f_20461_, extraData, powerCost, inputs);
    }

    public void addItemRecipes(String name, Item output, float powerCost, Ingredient ... inputs) {
        this.addItemRecipes(name, output.m_7968_(), powerCost, inputs);
    }

    public void addItemRecipes(String name, RegistryObject<Item> output, float powerCost, Ingredient ... inputs) {
        this.addItemRecipes(name, (Item)output.get(), powerCost, inputs);
    }

    public void addItemRecipes(RegistryObject<Item> output, float powerCost, Ingredient ... inputs) {
        ResourceLocation registryName = ((Item)output.get()).getRegistryName();
        if (registryName != null) {
            this.addItemRecipes("craft_" + registryName.m_135815_(), output, powerCost, inputs);
        }
    }

    public void addItemRecipes(RegistryObject<Item> output, Ingredient ... inputs) {
        this.addItemRecipes(output, 0.2f, inputs);
    }

    private JsonObject recipeToJson(AltarRecipe recipe) {
        JsonObject json = new JsonObject();
        json.addProperty("type", InitRecipes.ALTAR_CRAFTING.toString());
        JsonObject output = new JsonObject();
        ResourceLocation name = recipe.getEntityType().getRegistryName();
        if (name == null) {
            throw new JsonParseException("Entity Registry Name Not Found");
        }
        output.addProperty("type", name.toString());
        NBTToJson.getJson((Tag)recipe.getExtraData()).ifPresent(e -> output.add("nbt", e));
        if (recipe.getCopyInput() != Ingredient.f_43901_) {
            JsonObject copy = new JsonObject();
            copy.add("ingredient", recipe.getCopyInput().m_43942_());
            if (StringUtils.isNotBlank((CharSequence)recipe.getCopyTag())) {
                copy.addProperty("tag", recipe.getCopyTag());
            }
            output.add("copy", (JsonElement)copy);
        }
        json.add("output", (JsonElement)output);
        json.addProperty("power", (Number)Float.valueOf(recipe.getPowerCost()));
        JsonArray ingredients = new JsonArray();
        for (Ingredient ingredient : recipe.m_7527_()) {
            ingredients.add(ingredient.m_43942_());
        }
        json.add("ingredients", (JsonElement)ingredients);
        return json;
    }

    public String m_6055_() {
        return "Maid Altar Recipe";
    }
}

