/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAwaitTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidBegTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidClearHurtTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidClearSleepTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFindBedTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFollowOwnerTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidPanicTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidPickupEntitiesTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidReturnHomeTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRunAwayTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidSleepTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.UpdateActivityFromSchedule;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;

public final class MaidBrain {
    public static ImmutableList<MemoryModuleType<?>> getMemoryTypes() {
        return ImmutableList.of((Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26379_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26323_, (Object)MemoryModuleType.f_26381_, (Object)MemoryModuleType.f_26382_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_, (Object)((MemoryModuleType)InitEntities.TARGET_POS.get()));
    }

    public static ImmutableList<SensorType<? extends Sensor<? super EntityMaid>>> getSensorTypes() {
        return ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_, (Object)((SensorType)InitEntities.MAID_HOSTILES_SENSOR.get()), (Object)((SensorType)InitEntities.MAID_PICKUP_ENTITIES_SENSOR.get()));
    }

    public static void registerBrainGoals(Brain<EntityMaid> brain, EntityMaid maid) {
        MaidBrain.registerSchedule(brain, maid);
        MaidBrain.registerCoreGoals(brain);
        MaidBrain.registerPanicGoals(brain);
        MaidBrain.registerAwaitGoals(brain);
        MaidBrain.registerIdleGoals(brain);
        MaidBrain.registerWorkGoals(brain, maid);
        MaidBrain.registerRestGoals(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21889_(Activity.f_37979_);
        brain.m_21862_(maid.f_19853_.m_46468_(), maid.f_19853_.m_46467_());
    }

    private static void registerSchedule(Brain<EntityMaid> brain, EntityMaid maid) {
        switch (maid.getSchedule()) {
            case ALL: {
                brain.m_21912_((Schedule)InitEntities.MAID_ALL_DAY_SCHEDULES.get());
                break;
            }
            case NIGHT: {
                brain.m_21912_((Schedule)InitEntities.MAID_NIGHT_SHIFT_SCHEDULES.get());
                break;
            }
            default: {
                brain.m_21912_((Schedule)InitEntities.MAID_DAY_SHIFT_SCHEDULES.get());
            }
        }
    }

    private static void registerCoreGoals(Brain<EntityMaid> brain) {
        Pair swim = Pair.of((Object)0, (Object)new Swim(0.8f));
        Pair look = Pair.of((Object)0, (Object)new LookAtTargetSink(45, 90));
        Pair maidPanic = Pair.of((Object)1, (Object)((Object)new MaidPanicTask()));
        Pair maidAwait = Pair.of((Object)1, (Object)((Object)new MaidAwaitTask()));
        Pair interactWithDoor = Pair.of((Object)2, (Object)new InteractWithDoor());
        Pair walkToTarget = Pair.of((Object)2, (Object)new MoveToTargetSink());
        Pair followOwner = Pair.of((Object)3, (Object)((Object)new MaidFollowOwnerTask(0.5f, 8, 2)));
        Pair pickupItem = Pair.of((Object)10, (Object)((Object)new MaidPickupEntitiesTask(EntityMaid::isPickup, 8, 0.6f)));
        Pair maidReturnHome = Pair.of((Object)20, (Object)((Object)new MaidReturnHomeTask(0.5f)));
        Pair clearSleep = Pair.of((Object)99, (Object)((Object)new MaidClearSleepTask()));
        brain.m_21900_(Activity.f_37978_, ImmutableList.of((Object)swim, (Object)look, (Object)maidPanic, (Object)maidAwait, (Object)interactWithDoor, (Object)walkToTarget, (Object)followOwner, (Object)pickupItem, (Object)maidReturnHome, (Object)clearSleep));
    }

    private static void registerIdleGoals(Brain<EntityMaid> brain) {
        Pair lookToPlayer = Pair.of((Object)new SetEntityLookTarget(EntityType.f_20532_, 5.0f), (Object)1);
        Pair lookToMaid = Pair.of((Object)new SetEntityLookTarget(EntityMaid.TYPE, 5.0f), (Object)1);
        Pair lookToWolf = Pair.of((Object)new SetEntityLookTarget(EntityType.f_20499_, 5.0f), (Object)1);
        Pair lookToCat = Pair.of((Object)new SetEntityLookTarget(EntityType.f_20553_, 5.0f), (Object)1);
        Pair lookToParrot = Pair.of((Object)new SetEntityLookTarget(EntityType.f_20508_, 5.0f), (Object)1);
        Pair walkRandomly = Pair.of((Object)new RandomStroll(0.3f, 5, 3), (Object)1);
        Pair noLook = Pair.of((Object)new DoNothing(40, 80), (Object)2);
        RunOne firstShuffledTask = new RunOne((List)ImmutableList.of((Object)lookToPlayer, (Object)lookToMaid, (Object)lookToWolf, (Object)lookToCat, (Object)lookToParrot, (Object)walkRandomly, (Object)noLook));
        RunIf supplementedTask = new RunIf(e -> !e.isBegging(), (Behavior)firstShuffledTask);
        Pair beg = Pair.of((Object)5, (Object)((Object)new MaidBegTask()));
        Pair supplemented = Pair.of((Object)6, (Object)supplementedTask);
        Pair updateActivity = Pair.of((Object)99, (Object)new UpdateActivityFromSchedule());
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)beg, (Object)supplemented, (Object)updateActivity));
    }

    private static void registerWorkGoals(Brain<EntityMaid> brain, EntityMaid maid) {
        Pair updateActivity = Pair.of((Object)99, (Object)new UpdateActivityFromSchedule());
        ArrayList pairMaidList = maid.getTask().createBrainTasks(maid);
        if (pairMaidList.isEmpty()) {
            pairMaidList = Lists.newArrayList((Object[])new Pair[]{updateActivity});
        } else {
            pairMaidList.add((Pair<Integer, Behavior<? super EntityMaid>>)updateActivity);
        }
        pairMaidList.add(Pair.of((Object)6, (Object)((Object)new MaidBegTask())));
        brain.m_21900_(Activity.f_37980_, ImmutableList.copyOf((Collection)pairMaidList));
    }

    private static void registerRestGoals(Brain<EntityMaid> brain) {
        Pair findBed = Pair.of((Object)5, (Object)((Object)new MaidFindBedTask(0.6f, 12)));
        Pair sleep = Pair.of((Object)6, (Object)((Object)new MaidSleepTask()));
        Pair updateActivity = Pair.of((Object)99, (Object)new UpdateActivityFromSchedule());
        brain.m_21900_(Activity.f_37982_, ImmutableList.of((Object)findBed, (Object)sleep, (Object)updateActivity));
    }

    private static void registerPanicGoals(Brain<EntityMaid> brain) {
        Pair clearHurt = Pair.of((Object)5, (Object)((Object)new MaidClearHurtTask()));
        Pair runAway = Pair.of((Object)5, MaidRunAwayTask.entity((MemoryModuleType<? extends Entity>)MemoryModuleType.f_26323_, 0.7f, 6, false));
        Pair runAwayHurt = Pair.of((Object)5, MaidRunAwayTask.entity((MemoryModuleType<? extends Entity>)MemoryModuleType.f_26382_, 0.7f, 6, false));
        brain.m_21900_(Activity.f_37984_, ImmutableList.of((Object)clearHurt, (Object)runAway, (Object)runAwayHurt));
    }

    private static void registerAwaitGoals(Brain<EntityMaid> brain) {
        Pair lookToPlayer = Pair.of((Object)new SetEntityLookTarget(EntityType.f_20532_, 5.0f), (Object)1);
        Pair lookToMaid = Pair.of((Object)new SetEntityLookTarget(EntityMaid.TYPE, 5.0f), (Object)1);
        Pair lookToWolf = Pair.of((Object)new SetEntityLookTarget(EntityType.f_20499_, 5.0f), (Object)1);
        Pair lookToCat = Pair.of((Object)new SetEntityLookTarget(EntityType.f_20553_, 5.0f), (Object)1);
        Pair lookToParrot = Pair.of((Object)new SetEntityLookTarget(EntityType.f_20508_, 5.0f), (Object)1);
        Pair noLook = Pair.of((Object)new DoNothing(30, 60), (Object)2);
        Pair shuffled = Pair.of((Object)5, (Object)new RunOne((List)ImmutableList.of((Object)lookToPlayer, (Object)lookToMaid, (Object)lookToWolf, (Object)lookToCat, (Object)lookToParrot, (Object)noLook)));
        Pair updateActivity = Pair.of((Object)99, (Object)new UpdateActivityFromSchedule());
        brain.m_21900_(Activity.f_37992_, ImmutableList.of((Object)shuffled, (Object)updateActivity));
    }
}

