/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public abstract class MaidMoveToBlockTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 120;
    private final float movementSpeed;
    private final int searchRange;
    private final int verticalSearchRange;
    protected int verticalSearchStart;

    public MaidMoveToBlockTask(float movementSpeed, int searchRange) {
        this(movementSpeed, searchRange, 1);
    }

    public MaidMoveToBlockTask(float movementSpeed, int searchRange, int verticalSearchRange) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_ABSENT));
        this.movementSpeed = movementSpeed;
        this.searchRange = searchRange;
        this.verticalSearchRange = verticalSearchRange;
        this.setMaxCheckRate(120);
    }

    protected final void searchForDestination(ServerLevel worldIn, EntityMaid maid) {
        BlockPos blockpos = maid.m_142538_();
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        int y = this.verticalSearchStart;
        while (y <= this.verticalSearchRange) {
            for (int i = 0; i < this.searchRange; ++i) {
                int x = 0;
                while (x <= i) {
                    int z;
                    int n = z = x < i && x > -i ? i : 0;
                    while (z <= i) {
                        blockPos.m_122154_((Vec3i)blockpos, x, y - 1, z);
                        if (maid.m_21444_((BlockPos)blockPos) && this.shouldMoveTo(worldIn, maid, (BlockPos)blockPos) && this.checkPathReach(maid, (BlockPos)blockPos)) {
                            BehaviorUtils.m_22617_((LivingEntity)maid, (BlockPos)blockPos, (float)this.movementSpeed, (int)0);
                            maid.m_6274_().m_21879_((MemoryModuleType)InitEntities.TARGET_POS.get(), (Object)new BlockPosTracker((BlockPos)blockPos));
                            this.setNextCheckTickCount(5);
                            return;
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
            y = y > 0 ? -y : 1 - y;
        }
    }

    protected abstract boolean shouldMoveTo(ServerLevel var1, EntityMaid var2, BlockPos var3);

    protected boolean checkPathReach(EntityMaid maid, BlockPos pos) {
        return maid.canPathReach(pos);
    }
}

