/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class MaidReturnHomeTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 100;
    private static final int TOO_CLOSED_RANGE = 3;
    private static final int MAX_TELEPORT_ATTEMPTS_TIMES = 10;
    private static final int MIN_TELEPORT_DISTANCE = 12;
    private final float walkSpeed;

    public MaidReturnHomeTask(float walkSpeed) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
        this.walkSpeed = walkSpeed;
        this.setMaxCheckRate(100);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        return owner.m_21536_() && this.farAway(owner) && super.checkExtraStartConditions(worldIn, owner);
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        double distanceSqr = maid.m_21534_().m_123331_((Vec3i)maid.m_142538_());
        if (distanceSqr > 144.0) {
            this.teleportToPos(maid);
        } else {
            BehaviorUtils.m_22617_((LivingEntity)maid, (BlockPos)maid.m_21534_(), (float)this.walkSpeed, (int)1);
        }
    }

    private void teleportToPos(EntityMaid maid) {
        BlockPos blockPos = maid.m_21534_();
        for (int i = 0; i < 10; ++i) {
            int x = this.randomIntInclusive(maid.m_21187_(), -3, 3);
            int y = this.randomIntInclusive(maid.m_21187_(), -1, 1);
            int z = this.randomIntInclusive(maid.m_21187_(), -3, 3);
            if (!this.maybeTeleportTo(maid, blockPos.m_123341_() + x, blockPos.m_123342_() + y, blockPos.m_123343_() + z)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(EntityMaid maid, int x, int y, int z) {
        if (!this.canTeleportTo(maid, new BlockPos(x, y, z))) {
            return false;
        }
        maid.m_7678_((double)x + 0.5, y, (double)z + 0.5, maid.m_146908_(), maid.m_146909_());
        maid.m_21573_().m_26573_();
        maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        maid.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        maid.m_6274_().m_21936_(MemoryModuleType.f_26372_);
        maid.m_6274_().m_21936_(MemoryModuleType.f_26377_);
        return true;
    }

    private boolean canTeleportTo(EntityMaid maid, BlockPos pos) {
        BlockPathTypes pathNodeType = WalkNodeEvaluator.m_77604_((BlockGetter)maid.f_19853_, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathNodeType == BlockPathTypes.WALKABLE) {
            BlockPos blockPos = pos.m_141950_((Vec3i)maid.m_142538_());
            return maid.f_19853_.m_45756_((Entity)maid, maid.m_142469_().m_82338_(blockPos));
        }
        return false;
    }

    private int randomIntInclusive(Random random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    private boolean farAway(EntityMaid maid) {
        return maid.m_21534_().m_123331_((Vec3i)maid.m_142538_()) > 9.0;
    }
}

