/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ProjectileWeaponItem;

public class MaidShootTargetTask
extends Behavior<EntityMaid> {
    private final int attackCooldown;
    private int attackTime = -1;
    private int seeTime;

    public MaidShootTargetTask(int attackCooldown) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), 1200);
        this.attackCooldown = attackCooldown;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        Optional memory = owner.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        if (memory.isPresent()) {
            LivingEntity target = (LivingEntity)memory.get();
            return owner.m_21093_(item -> item.m_41720_() instanceof ProjectileWeaponItem) && BehaviorUtils.m_22667_((LivingEntity)owner, (LivingEntity)target) && BehaviorUtils.m_22632_((Mob)owner, (LivingEntity)target, (int)0);
        }
        return false;
    }

    protected boolean canStillUse(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        return entityIn.m_6274_().m_21874_(MemoryModuleType.f_26372_) && this.checkExtraStartConditions(worldIn, entityIn);
    }

    protected void start(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    protected void tick(ServerLevel worldIn, EntityMaid owner, long gameTime) {
        owner.m_6274_().m_21952_(MemoryModuleType.f_26372_).ifPresent(target -> {
            boolean seeTimeMoreThanZero;
            boolean canSee = BehaviorUtils.m_22667_((LivingEntity)owner, (LivingEntity)target);
            boolean bl = seeTimeMoreThanZero = this.seeTime > 0;
            if (canSee != seeTimeMoreThanZero) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (owner.m_6117_()) {
                int ticksUsingItem;
                if (!canSee && this.seeTime < -60) {
                    owner.m_5810_();
                } else if (canSee && (ticksUsingItem = owner.m_21252_()) >= 20) {
                    owner.m_5810_();
                    owner.m_6504_((LivingEntity)target, BowItem.m_40661_((int)ticksUsingItem));
                    this.attackTime = this.attackCooldown;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                owner.m_6672_(InteractionHand.MAIN_HAND);
            }
        });
    }

    protected void stop(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        this.seeTime = 0;
        this.attackTime = -1;
        entityIn.m_5810_();
    }
}

