/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SnowballItem;

public class MaidSnowballTargetTask
extends Behavior<EntityMaid> {
    private static final int MAX_STOP_ATTACK_DISTANCE = 16;
    private static final float CHANCE_STOPPING = 0.03125f;
    private final int attackCooldown;
    private boolean canThrow = false;
    private int attackTime = -1;

    public MaidSnowballTargetTask(int attackCooldown) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), 1200);
        this.attackCooldown = attackCooldown;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        Optional memory = owner.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        if (memory.isPresent()) {
            LivingEntity target = (LivingEntity)memory.get();
            return owner.m_21093_(item -> item.m_41720_() instanceof SnowballItem || item.m_41619_()) && BehaviorUtils.m_22667_((LivingEntity)owner, (LivingEntity)target) && this.inMaxDistance((LivingEntity)owner);
        }
        return false;
    }

    protected boolean canStillUse(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        return this.chanceStop((LivingEntity)entityIn) && entityIn.m_6274_().m_21874_(MemoryModuleType.f_26372_) && this.isCurrentTargetInSameLevel((LivingEntity)entityIn) && this.isCurrentTargetAlive((LivingEntity)entityIn) && this.checkExtraStartConditions(worldIn, entityIn);
    }

    protected void start(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        if (entityIn.m_21205_().m_41619_()) {
            entityIn.m_21008_(InteractionHand.MAIN_HAND, Items.f_42452_.m_7968_());
            return;
        }
        if (!(entityIn.m_21205_().m_41720_() instanceof SnowballItem) && entityIn.m_21206_().m_41619_()) {
            entityIn.m_21008_(InteractionHand.OFF_HAND, Items.f_42452_.m_7968_());
        }
    }

    protected void tick(ServerLevel worldIn, EntityMaid owner, long gameTime) {
        owner.m_6274_().m_21952_(MemoryModuleType.f_26372_).ifPresent(target -> {
            boolean canSee = BehaviorUtils.m_22667_((LivingEntity)owner, (LivingEntity)target);
            if (this.canThrow && canSee) {
                this.canThrow = false;
                if (owner.m_21205_().m_41720_() instanceof SnowballItem) {
                    owner.m_6674_(InteractionHand.MAIN_HAND);
                } else {
                    owner.m_6674_(InteractionHand.OFF_HAND);
                }
                BehaviorUtils.m_22595_((LivingEntity)owner, (LivingEntity)target);
                this.performRangedAttack(owner, (LivingEntity)target);
                this.attackTime = this.attackCooldown + owner.m_21187_().nextInt(this.attackCooldown);
            } else if (--this.attackTime <= 0) {
                this.canThrow = true;
            }
        });
    }

    private void performRangedAttack(EntityMaid shooter, LivingEntity target) {
        Snowball snowball = new Snowball(shooter.f_19853_, (LivingEntity)shooter);
        double x = target.m_20185_() - shooter.m_20185_();
        double y = target.m_142469_().f_82289_ + (double)(target.m_20206_() / 3.0f) - snowball.m_20182_().f_82480_;
        double z = target.m_20189_() - shooter.m_20189_();
        double pitch = Math.sqrt(x * x + z * z) * 0.15;
        snowball.m_6686_(x, y + pitch, z, 1.6f, 1.0f);
        shooter.m_5496_(SoundEvents.f_12473_, 0.5f, 0.4f / (shooter.m_21187_().nextFloat() * 0.4f + 0.8f));
        shooter.f_19853_.m_7967_((Entity)snowball);
    }

    protected void stop(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        this.attackTime = -1;
        this.canThrow = false;
        this.clearAttackTarget((LivingEntity)entityIn);
    }

    private boolean isCurrentTargetInSameLevel(LivingEntity entity) {
        Optional optional = entity.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        return optional.isPresent() && ((LivingEntity)optional.get()).f_19853_ == entity.f_19853_;
    }

    private boolean isCurrentTargetAlive(LivingEntity entity) {
        Optional optional = entity.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        return optional.isPresent() && ((LivingEntity)optional.get()).m_6084_();
    }

    private boolean inMaxDistance(LivingEntity entity) {
        Optional optional = entity.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        return optional.isPresent() && entity.m_20270_((Entity)optional.get()) <= 16.0f;
    }

    private boolean chanceStop(LivingEntity entity) {
        return entity.m_21187_().nextFloat() > 0.03125f;
    }

    private void clearAttackTarget(LivingEntity entity) {
        entity.m_6274_().m_21936_(MemoryModuleType.f_26372_);
    }
}

