/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class AbstractEntityFromItem
extends LivingEntity {
    public AbstractEntityFromItem(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected abstract boolean canKillEntity(Player var1);

    protected abstract SoundEvent getHitSound();

    protected abstract Item getWithItem();

    protected abstract ItemStack getKilledStack();

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        if (!this.f_19853_.f_46443_ && !this.f_20890_ && this.m_6084_()) {
            if (this.m_6673_(source)) {
                return false;
            }
            if (source.m_7640_() instanceof Player) {
                return this.applyHitEntityLogic((Player)source.m_7640_());
            }
        }
        return false;
    }

    private boolean applyHitEntityLogic(Player player) {
        if (player.m_6144_()) {
            this.m_20153_();
            this.m_5496_(this.getHitSound(), 1.0f, 1.0f);
            if (player.m_7500_() && !this.m_8077_()) {
                this.m_146870_();
            } else if (this.canKillEntity(player)) {
                this.killEntity();
            }
            LazyOptional itemHandler = this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (!this.f_19853_.f_46443_) {
                itemHandler.ifPresent(handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack itemstack = handler.getStackInSlot(i);
                        Containers.m_18992_((Level)this.f_19853_, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)itemstack);
                    }
                });
            }
        }
        return true;
    }

    private void killEntity() {
        this.m_146870_();
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            ItemStack itemstack = this.getKilledStack();
            if (this.m_8077_()) {
                itemstack.m_41714_(this.m_7770_());
            }
            this.m_5552_(itemstack, 0.0f);
        }
    }

    public void m_147240_(double strength, double ratioX, double ratioZ) {
    }

    public boolean m_5789_() {
        return false;
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.LEFT;
    }
}

