/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class EntityBox
extends Entity {
    public static final int FIRST_STAGE = 64;
    public static final int SECOND_STAGE = 60;
    public static final int THIRD_STAGE = 0;
    public static final int MAX_TEXTURE_SIZE = 7;
    private static final EntityDataAccessor<Integer> OPEN_STAGE = SynchedEntityData.m_135353_(EntityBox.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TEXTURE_INDEX = SynchedEntityData.m_135353_(EntityBox.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityType<EntityBox> TYPE = EntityType.Builder.m_20704_(EntityBox::new, (MobCategory)MobCategory.MISC).m_20699_(2.0f, 2.0f).m_20702_(10).m_20712_("box");
    private static final String STAGE_TAG = "OpenStage";
    private static final String TEXTURE_TAG = "TextureIndex";

    public EntityBox(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.setRandomTexture();
    }

    public EntityBox(Level worldIn) {
        this(TYPE, worldIn);
    }

    public void m_6075_() {
        if (!this.m_20068_() && !this.f_19861_) {
            this.m_6478_(MoverType.SELF, this.m_20184_().m_82520_(0.0, -0.1, 0.0));
        }
        super.m_6075_();
        int stage = this.getOpenStage();
        this.stageChange(stage);
        this.m_20197_().stream().filter(e -> e instanceof TamableAnimal).forEach(e -> this.applyInvisibilityEffect((TamableAnimal)e, stage));
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.getOpenStage() == 64) {
            this.setOpenStage(63);
            this.m_5496_((SoundEvent)InitSounds.BOX_OPEN.get(), 3.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.getOpenStage() == 60) {
            this.setOpenStage(59);
            this.m_5496_((SoundEvent)InitSounds.BOX_OPEN.get(), 3.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.getOpenStage() == 0) {
            this.setOpenStage(-1);
            this.m_5496_((SoundEvent)InitSounds.BOX_OPEN.get(), 3.0f, 2.0f);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6096_(player, hand);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OPEN_STAGE, (Object)64);
        this.f_19804_.m_135372_(TEXTURE_INDEX, (Object)0);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_(STAGE_TAG)) {
            this.setOpenStage(compound.m_128451_(STAGE_TAG));
        }
        if (compound.m_128441_(TEXTURE_TAG)) {
            this.setTextureIndex(compound.m_128451_(TEXTURE_TAG));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_(STAGE_TAG, this.getOpenStage());
        compound.m_128405_(TEXTURE_TAG, this.getTextureIndex());
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public double m_6048_() {
        return 0.0;
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public int getOpenStage() {
        return (Integer)this.f_19804_.m_135370_(OPEN_STAGE);
    }

    public void setOpenStage(int stage) {
        this.f_19804_.m_135381_(OPEN_STAGE, (Object)Mth.m_14045_((int)stage, (int)-1, (int)64));
    }

    public int getTextureIndex() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE_INDEX);
    }

    public void setTextureIndex(int index) {
        this.f_19804_.m_135381_(TEXTURE_INDEX, (Object)Mth.m_14045_((int)index, (int)1, (int)6));
    }

    public void setRandomTexture() {
        this.setTextureIndex(this.f_19796_.nextInt(7));
    }

    private void stageChange(int stage) {
        if (stage != 64 && stage != 60 && stage != 0) {
            this.setOpenStage(stage - 1);
        }
        if (stage < 0) {
            this.m_146870_();
            if (!this.f_19853_.f_46443_) {
                this.m_20000_((ItemLike)Items.f_42516_, 2 + this.f_19796_.nextInt(3));
            }
        }
    }

    private void applyInvisibilityEffect(TamableAnimal tameable, int stage) {
        if (stage >= 64) {
            tameable.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 2, 1, false, false));
        }
    }
}

