/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.ChairConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityFromItem;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemChair;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenChairGuiMessage;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.util.thread.EffectiveSide;

public class EntityChair
extends AbstractEntityFromItem {
    public static final EntityType<EntityChair> TYPE = EntityType.Builder.m_20704_(EntityChair::new, (MobCategory)MobCategory.MISC).m_20699_(0.875f, 0.5f).m_20702_(10).m_20712_("chair");
    private static final EntityDataAccessor<String> MODEL_ID = SynchedEntityData.m_135353_(EntityChair.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> MOUNTED_HEIGHT = SynchedEntityData.m_135353_(EntityChair.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> TAMEABLE_CAN_RIDE = SynchedEntityData.m_135353_(EntityChair.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(EntityChair.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final String MODEL_ID_TAG = "ModelId";
    private static final String MOUNTED_HEIGHT_TAG = "MountedHeight";
    private static final String TAMEABLE_CAN_RIDE_TAG = "TameableCanRide";
    private static final String OWNER_UUID_TAG = "OwnerUUID";
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:cushion";

    protected EntityChair(EntityType<EntityChair> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityChair(Level worldIn) {
        this(TYPE, worldIn);
    }

    public EntityChair(Level worldIn, double x, double y, double z, float yaw) {
        this(TYPE, worldIn);
        this.m_6034_(x, y, z);
        this.m_19915_(yaw, 0.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MODEL_ID, (Object)DEFAULT_MODEL_ID);
        this.f_19804_.m_135372_(MOUNTED_HEIGHT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TAMEABLE_CAN_RIDE, (Object)true);
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
    }

    protected void m_6138_() {
        if (!this.isTameableCanRide()) {
            return;
        }
        if (!this.f_19853_.f_46443_) {
            List list = this.f_19853_.m_6443_(TamableAnimal.class, this.m_142469_().m_82363_(0.0, 0.5, 0.0), e -> !e.m_21825_() && !e.m_20159_() && e.m_20197_().isEmpty());
            list.stream().findFirst().ifPresent(entity -> entity.m_20329_((Entity)this));
        }
    }

    public void m_7334_(Entity entityIn) {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6087_() {
        return !EffectiveSide.get().isServer();
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_6144_()) {
            if (player.m_21120_(hand).m_41647_(player, (LivingEntity)this, hand).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (!this.f_19853_.f_46443_) {
                NetworkHandler.sendToClientPlayer(new OpenChairGuiMessage(this.m_142049_()), player);
            }
        } else if (!this.f_19853_.f_46443_ && this.m_20197_().isEmpty() && !player.m_20159_()) {
            player.m_20329_((Entity)this);
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public AABB m_6921_() {
        BedrockModel model = CustomPackLoader.CHAIR_MODELS.getModel(this.getModelId()).orElse(null);
        if (model == null) {
            return super.m_6921_();
        }
        return model.getRenderBoundingBox().m_82383_(this.m_20182_());
    }

    public double m_6048_() {
        return this.getMountedHeight();
    }

    @Override
    protected boolean canKillEntity(Player player) {
        if (((Boolean)ChairConfig.CHAIR_CAN_DESTROYED_BY_ANYONE.get()).booleanValue()) {
            return true;
        }
        return this.getOwnerUUID().map(uuid -> player.m_142081_().equals(uuid)).orElse(true);
    }

    @Override
    protected SoundEvent getHitSound() {
        return SoundEvents.f_12639_;
    }

    @Override
    protected Item getWithItem() {
        return (Item)InitItems.CHAIR.get();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_(MODEL_ID_TAG, 8)) {
            this.setModelId(compound.m_128461_(MODEL_ID_TAG));
        }
        if (compound.m_128425_(MOUNTED_HEIGHT_TAG, 5)) {
            this.setMountedHeight(compound.m_128457_(MOUNTED_HEIGHT_TAG));
        }
        if (compound.m_128425_(TAMEABLE_CAN_RIDE_TAG, 1)) {
            this.setTameableCanRide(compound.m_128471_(TAMEABLE_CAN_RIDE_TAG));
        }
        if (compound.m_128441_(OWNER_UUID_TAG)) {
            this.setOwnerUUID(NbtUtils.m_129233_((Tag)Objects.requireNonNull(compound.m_128423_(OWNER_UUID_TAG))));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_(MODEL_ID_TAG, this.getModelId());
        compound.m_128350_(MOUNTED_HEIGHT_TAG, this.getMountedHeight());
        compound.m_128379_(TAMEABLE_CAN_RIDE_TAG, this.isTameableCanRide());
        this.getOwnerUUID().ifPresent(uuid -> compound.m_128362_(OWNER_UUID_TAG, uuid));
    }

    @Nullable
    public Entity m_6688_() {
        List list = this.m_20197_();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public String getModelId() {
        return (String)this.f_19804_.m_135370_(MODEL_ID);
    }

    public void setModelId(String modelId) {
        this.f_19804_.m_135381_(MODEL_ID, (Object)modelId);
    }

    public float getMountedHeight() {
        return ((Float)this.f_19804_.m_135370_(MOUNTED_HEIGHT)).floatValue();
    }

    public void setMountedHeight(float height) {
        height = Mth.m_14036_((float)height, (float)-0.5f, (float)2.5f);
        this.f_19804_.m_135381_(MOUNTED_HEIGHT, (Object)Float.valueOf(height));
    }

    public boolean isTameableCanRide() {
        return (Boolean)this.f_19804_.m_135370_(TAMEABLE_CAN_RIDE);
    }

    public void setTameableCanRide(boolean canRide) {
        this.f_19804_.m_135381_(TAMEABLE_CAN_RIDE, (Object)canRide);
    }

    public Optional<UUID> getOwnerUUID() {
        return (Optional)this.f_19804_.m_135370_(OWNER_UUID);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void setOwner(@Nullable Player player) {
        if (player != null) {
            this.setOwnerUUID(player.m_142081_());
        }
    }

    public boolean hasPassenger() {
        return !this.m_20197_().isEmpty();
    }

    public float getPassengerYaw() {
        if (!this.m_20197_().isEmpty()) {
            return ((Entity)this.m_20197_().get(0)).m_146908_();
        }
        return 0.0f;
    }

    public float getYaw() {
        return this.m_146908_();
    }

    public float getPassengerPitch() {
        if (!this.m_20197_().isEmpty()) {
            return ((Entity)this.m_20197_().get(0)).m_146909_();
        }
        return 0.0f;
    }

    @Deprecated
    public int getDim() {
        ResourceKey dim = this.f_19853_.m_46472_();
        if (dim.equals((Object)Level.f_46428_)) {
            return 0;
        }
        if (dim.equals((Object)Level.f_46429_)) {
            return -1;
        }
        if (dim.equals((Object)Level.f_46430_)) {
            return 1;
        }
        return 0;
    }

    @Override
    protected ItemStack getKilledStack() {
        return ItemChair.setData(((Item)InitItems.CHAIR.get()).m_7968_(), new ItemChair.Data(this.getModelId(), this.getMountedHeight(), this.isTameableCanRide(), this.m_20068_()));
    }
}

