/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.monster;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.goal.FairyAttackGoal;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.FairyType;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.IHasPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuShoot;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class EntityFairy
extends Monster
implements RangedAttackMob,
FlyingAnimal,
IHasPowerPoint {
    public static final EntityType<EntityFairy> TYPE = EntityType.Builder.m_20704_(EntityFairy::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.5f).m_20702_(10).m_20712_("fairy");
    private static final String FAIRY_TYPE_TAG_NAME = "FairyType";
    private static final EntityDataAccessor<Integer> FAIRY_TYPE = SynchedEntityData.m_135353_(EntityFairy.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final double AIMED_SHOT_PROBABILITY = 0.9;

    protected EntityFairy(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 15, true);
    }

    public EntityFairy(Level worldIn) {
        this(TYPE, worldIn);
    }

    public static AttributeSupplier.Builder createFairyAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 1.5).m_22268_(Attributes.f_22284_, 1.0).m_22268_(Attributes.f_22280_, 0.4);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FairyAttackGoal(this, 6.0, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, EntityMaid.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, EntityMaid.class, 10, true, false, e -> !e.m_5803_()));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FAIRY_TYPE, (Object)FairyType.BLACK.ordinal());
    }

    @Override
    public int getPowerPoint() {
        return (int)((Double)MiscConfig.MAID_FAIRY_POWER_POINT.get() * 100.0);
    }

    protected void m_6153_() {
        super.m_6153_();
        this.dropPowerPoint((LivingEntity)this);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if ((double)this.f_19796_.nextFloat() <= 0.9) {
            DanmakuShoot.create().setWorld(this.f_19853_).setThrower((LivingEntity)this).setTarget(target).setRandomColor().setRandomType().setDamage(distanceFactor + 1.0f).setGravity(0.0f).setVelocity(0.2f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).aimedShot();
        } else {
            DanmakuShoot.create().setWorld(this.f_19853_).setThrower((LivingEntity)this).setTarget(target).setRandomColor().setRandomType().setDamage(distanceFactor + 1.5f).setGravity(0.0f).setVelocity(0.2f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).setFanNum(3).setYawTotal(0.5235987755982988).fanShapedShot();
        }
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation navigator = new FlyingPathNavigation((Mob)this, worldIn);
        navigator.m_26440_(false);
        navigator.m_7008_(true);
        navigator.m_26443_(true);
        return navigator;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setFairyTypeOrdinal(this.f_19796_.nextInt(FairyType.values().length));
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_(FAIRY_TYPE_TAG_NAME, this.getFairyTypeOrdinal());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_(FAIRY_TYPE_TAG_NAME, 3)) {
            this.setFairyTypeOrdinal(compound.m_128451_(FAIRY_TYPE_TAG_NAME));
        }
    }

    public int getFairyTypeOrdinal() {
        return (Integer)this.f_19804_.m_135370_(FAIRY_TYPE);
    }

    public void setFairyTypeOrdinal(int ordinal) {
        this.f_19804_.m_135381_(FAIRY_TYPE, (Object)ordinal);
    }

    public boolean m_142592_() {
        return !this.f_19861_;
    }
}

