/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.projectile;

import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuColor;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuType;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.EntityDanmaku;
import java.util.Random;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class DanmakuShoot {
    private static final Random RANDOM = new Random();
    private static final double MAX_YAW = Math.PI * 2;
    private static final int MIN_FAN_NUM = 2;
    private Level world;
    private LivingEntity thrower;
    private DanmakuColor color;
    private DanmakuType type;
    private float gravity;
    private float damage;
    private LivingEntity target;
    private float velocity;
    private float inaccuracy;
    private double yawTotal;
    private int fanNum;

    public static DanmakuShoot create() {
        return new DanmakuShoot();
    }

    public void aimedShot() {
        if (!this.world.f_46443_) {
            EntityDanmaku danmaku = new EntityDanmaku(this.world, this.thrower).setDamage(this.damage).setGravityVelocity(this.gravity).setDanmakuType(this.type).setColor(this.color);
            float offset = 0.3f / this.target.m_20206_();
            danmaku.m_6686_(this.target.m_20185_() - this.thrower.m_20185_(), this.target.m_20186_() - this.thrower.m_20186_() - (double)offset, this.target.m_20189_() - this.thrower.m_20189_(), this.velocity, this.inaccuracy);
            this.world.m_7967_((Entity)danmaku);
        }
        this.world.m_6263_(null, this.thrower.m_20185_(), this.thrower.m_20186_(), this.thrower.m_20189_(), SoundEvents.f_12473_, this.thrower.m_5720_(), 1.0f, 0.8f);
    }

    public void fanShapedShot() {
        if (this.yawTotal < 0.0 || this.yawTotal > Math.PI * 2 || this.fanNum < 2) {
            return;
        }
        if (!this.world.f_46443_) {
            float offset = 0.3f / this.target.m_20206_();
            Vec3 v = new Vec3(this.target.m_20185_() - this.thrower.m_20185_(), this.target.m_20186_() - this.thrower.m_20186_() - (double)offset, this.target.m_20189_() - this.thrower.m_20189_());
            double yaw = -(this.yawTotal / 2.0);
            double addYaw = this.yawTotal / (double)(this.fanNum - 1);
            for (int i = 1; i <= this.fanNum; ++i) {
                Vec3 v1 = v.m_82524_((float)yaw);
                yaw += addYaw;
                EntityDanmaku danmaku = new EntityDanmaku(this.world, this.thrower).setDamage(this.damage).setGravityVelocity(this.gravity).setDanmakuType(this.type).setColor(this.color);
                danmaku.m_6686_(v1.f_82479_, v1.f_82480_, v1.f_82481_, this.velocity, this.inaccuracy);
                this.world.m_7967_((Entity)danmaku);
            }
        }
        this.world.m_6263_(null, this.thrower.m_20185_(), this.thrower.m_20186_(), this.thrower.m_20189_(), SoundEvents.f_12473_, this.thrower.m_5720_(), 1.0f, 0.8f);
    }

    public DanmakuShoot setWorld(Level world) {
        this.world = world;
        return this;
    }

    public DanmakuShoot setThrower(LivingEntity thrower) {
        this.thrower = thrower;
        return this;
    }

    public DanmakuShoot setColor(DanmakuColor color) {
        this.color = color;
        return this;
    }

    public DanmakuShoot setRandomColor() {
        this.color = DanmakuColor.random(RANDOM);
        return this;
    }

    public DanmakuShoot setType(DanmakuType type) {
        this.type = type;
        return this;
    }

    public DanmakuShoot setRandomType() {
        this.type = DanmakuType.random(RANDOM);
        return this;
    }

    public DanmakuShoot setGravity(float gravity) {
        this.gravity = gravity;
        return this;
    }

    public DanmakuShoot setDamage(float damage) {
        this.damage = damage;
        return this;
    }

    public DanmakuShoot setTarget(LivingEntity target) {
        this.target = target;
        return this;
    }

    public DanmakuShoot setVelocity(float velocity) {
        this.velocity = velocity;
        return this;
    }

    public DanmakuShoot setInaccuracy(float inaccuracy) {
        this.inaccuracy = inaccuracy;
        return this;
    }

    public DanmakuShoot setYawTotal(double yawTotal) {
        this.yawTotal = yawTotal;
        return this;
    }

    public DanmakuShoot setFanNum(int fanNum) {
        this.fanNum = fanNum;
        return this;
    }
}

