/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAttackStrafingTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuShoot;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TaskDanmakuAttack
implements IRangedAttackTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "danmaku_attack");
    private static final int MAX_STOP_ATTACK_DISTANCE = 16;

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return ((Item)InitItems.HAKUREI_GOHEI.get()).m_7968_();
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, (SoundEvent)InitSounds.MAID_DANMAKU_ATTACK.get(), 0.5f);
    }

    @Override
    public List<Pair<Integer, Behavior<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        RunIf supplementedTask = new RunIf(this::hasGohei, (Behavior)new StartAttacking(IAttackTask::findFirstValidAttackTarget));
        StopAttackingIfTargetInvalid findTargetTask = new StopAttackingIfTargetInvalid(target -> !this.hasGohei(maid) || this.farAway((LivingEntity)target, maid));
        SetWalkTargetFromAttackTargetIfTargetOutOfReach moveToTargetTask = new SetWalkTargetFromAttackTargetIfTargetOutOfReach(0.6f);
        MaidAttackStrafingTask maidAttackStrafingTask = new MaidAttackStrafingTask();
        MaidShootTargetTask shootTargetTask = new MaidShootTargetTask(2);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)moveToTargetTask), Pair.of((Object)5, (Object)((Object)maidAttackStrafingTask)), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public void performRangedAttack(EntityMaid shooter, LivingEntity target, float distanceFactor) {
        shooter.m_6274_().m_21952_(MemoryModuleType.f_148204_).ifPresent(livingEntities -> {
            ItemStack mainHandItem = shooter.m_21205_();
            if (mainHandItem.m_41720_() == InitItems.HAKUREI_GOHEI.get()) {
                long entityCount = livingEntities.stream().filter(shooter::m_6779_).count();
                Level level = shooter.f_19853_;
                if (entityCount <= 1L) {
                    DanmakuShoot.create().setWorld(level).setThrower((LivingEntity)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(2.0f * (distanceFactor + 1.0f)).setGravity(0.0f).setVelocity(0.3f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).aimedShot();
                } else if (entityCount <= 5L) {
                    DanmakuShoot.create().setWorld(level).setThrower((LivingEntity)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(2.0f * (distanceFactor + 1.2f)).setGravity(0.0f).setVelocity(0.3f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).setFanNum(8).setYawTotal(1.0471975511965976).fanShapedShot();
                } else {
                    DanmakuShoot.create().setWorld(level).setThrower((LivingEntity)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(2.0f * (distanceFactor + 1.5f)).setGravity(0.0f).setVelocity(0.3f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).setFanNum(32).setYawTotal(2.0943951023931953).fanShapedShot();
                }
                mainHandItem.m_41622_(1, (LivingEntity)shooter, maid -> maid.m_21190_(InteractionHand.MAIN_HAND));
            }
        });
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.singletonList(Pair.of((Object)"has_gohei", this::hasGohei));
    }

    private boolean hasGohei(EntityMaid maid) {
        return maid.m_21205_().m_41720_() == InitItems.HAKUREI_GOHEI.get();
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.m_20270_((Entity)target) > 16.0f;
    }
}

