/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidBegTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidSnowballTargetTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidStartSnowballAttacking;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;

public class TaskIdle
implements IMaidTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "idle");
    private static final float LOW_TEMPERATURE = 0.15f;

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.f_42402_.m_7968_();
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound(maid, (SoundEvent)InitSounds.MAID_IDLE.get(), 0.5f);
    }

    @Override
    public List<Pair<Integer, Behavior<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        Pair lookToPlayer = Pair.of((Object)new SetEntityLookTarget(EntityType.f_20532_, 5.0f), (Object)1);
        Pair lookToMaid = Pair.of((Object)new SetEntityLookTarget(EntityMaid.TYPE, 5.0f), (Object)1);
        Pair lookToWolf = Pair.of((Object)new SetEntityLookTarget(EntityType.f_20499_, 5.0f), (Object)1);
        Pair lookToCat = Pair.of((Object)new SetEntityLookTarget(EntityType.f_20553_, 5.0f), (Object)1);
        Pair lookToParrot = Pair.of((Object)new SetEntityLookTarget(EntityType.f_20508_, 5.0f), (Object)1);
        Pair noLook = Pair.of((Object)new DoNothing(20, 40), (Object)2);
        Pair findSnowballTarget = Pair.of(new MaidStartSnowballAttacking<EntityMaid>(this::canSnowballFight, this::findFirstValidSnowballTarget), (Object)2);
        RunOne firstShuffledTask = new RunOne((List)ImmutableList.of((Object)lookToPlayer, (Object)lookToMaid, (Object)lookToWolf, (Object)lookToCat, (Object)lookToParrot, (Object)findSnowballTarget, (Object)noLook));
        RunIf randomLookTask = new RunIf(e -> !e.isBegging(), (Behavior)firstShuffledTask);
        MaidSnowballTargetTask snowballTargetTask = new MaidSnowballTargetTask(40);
        Pair beg = Pair.of((Object)5, (Object)((Object)new MaidBegTask()));
        Pair supplemented = Pair.of((Object)6, (Object)randomLookTask);
        Pair snowballFight = Pair.of((Object)6, (Object)((Object)snowballTargetTask));
        return Lists.newArrayList((Object[])new Pair[]{beg, supplemented, snowballFight});
    }

    private boolean canSnowballFight(EntityMaid maid) {
        Level world = maid.f_19853_;
        BlockPos pos = maid.m_142538_();
        return !maid.isBegging() && ((Biome)world.m_204166_(pos).m_203334_()).m_198904_(pos) && world.m_8055_(pos).m_60713_(Blocks.f_50125_);
    }

    private Optional<? extends LivingEntity> findFirstValidSnowballTarget(EntityMaid maid) {
        return maid.m_6274_().m_21952_(MemoryModuleType.f_148205_).flatMap(list -> list.m_186128_(e -> this.isSnowballTarget((LivingEntity)e, maid)).filter(e -> maid.m_21444_(e.m_142538_())).findFirst());
    }

    private boolean isSnowballTarget(LivingEntity entity, EntityMaid maid) {
        if (maid.m_21830_(entity)) {
            return true;
        }
        if (entity instanceof EntityMaid && maid.m_142480_() != null) {
            EntityMaid maidOther = (EntityMaid)entity;
            return maid.m_142480_().equals((Object)maidOther.m_142480_());
        }
        return false;
    }
}

