/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container;

import com.github.tartaricacid.touhoulittlemaid.client.event.ReloadResourceEvent;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class MaidMainContainer
extends AbstractMaidContainer {
    public static final MenuType<MaidMainContainer> TYPE = IForgeMenuType.create((windowId, inv, data) -> new MaidMainContainer(windowId, inv, data.readInt()));
    private static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private static final int PLAYER_INVENTORY_SIZE = 36;

    public MaidMainContainer(int id, Inventory inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
        if (this.maid != null) {
            this.addMaidArmorInv();
            this.addMaidBauble();
            this.addMaidHandInv();
            this.addMainInv();
        }
    }

    public static MenuProvider create(final int entityId) {
        return new MenuProvider(){

            public Component m_5446_() {
                return new TextComponent("Maid Main Container");
            }

            public AbstractMaidContainer createMenu(int index, Inventory playerInventory, Player player) {
                return new MaidMainContainer(index, playerInventory, entityId);
            }
        };
    }

    private void addMaidHandInv() {
        LazyOptional hand = this.maid.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN);
        hand.ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 0, 87, 79){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)ReloadResourceEvent.EMPTY_MAINHAND_SLOT);
            }
        }));
        hand.ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 1, 121, 79){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        }));
    }

    private void addMaidArmorInv() {
        LazyOptional armor = this.maid.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST);
        armor.ifPresent(handler -> {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    final EquipmentSlot EquipmentSlot2 = SLOT_IDS[2 * i + j];
                    this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 3 - 2 * i - j, 94 + 20 * j, 37 + 20 * i){

                        public int m_6641_() {
                            return 1;
                        }

                        public boolean m_5857_(@Nonnull ItemStack stack) {
                            return stack.canEquip(EquipmentSlot2, (Entity)MaidMainContainer.this.maid);
                        }

                        public boolean m_8010_(Player playerIn) {
                            ItemStack itemstack = this.m_7993_();
                            boolean curseEnchant = !itemstack.m_41619_() && !playerIn.m_7500_() && EnchantmentHelper.m_44920_((ItemStack)itemstack);
                            return !curseEnchant && super.m_8010_(playerIn);
                        }

                        @OnlyIn(value=Dist.CLIENT)
                        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                            return Pair.of((Object)InventoryMenu.f_39692_, (Object)TEXTURE_EMPTY_SLOTS[EquipmentSlot2.m_20749_()]);
                        }
                    });
                }
            }
        });
    }

    private void addMainInv() {
        int i;
        ItemStackHandler inv = this.maid.getMaidInv();
        int level = this.maid.getBackpackLevel();
        for (i = 0; i < 6; ++i) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inv, i, 143 + 18 * i, 37));
            if (i != 5) continue;
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inv, i, 143 + 18 * i, 37){

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)ReloadResourceEvent.EMPTY_BACK_SHOW_SLOT);
                }
            });
        }
        if (level > 0) {
            for (i = 0; i < 6; ++i) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inv, 6 + i, 143 + 18 * i, 59));
            }
        }
        if (level > 1) {
            for (i = 0; i < 6; ++i) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inv, 12 + i, 143 + 18 * i, 82));
            }
            for (i = 0; i < 6; ++i) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inv, 18 + i, 143 + 18 * i, 100));
            }
        }
        if (level > 2) {
            for (i = 0; i < 6; ++i) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inv, 24 + i, 143 + 18 * i, 123));
            }
            for (i = 0; i < 6; ++i) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inv, 30 + i, 143 + 18 * i, 141));
            }
        }
    }

    private void addMaidBauble() {
        BaubleItemHandler maidBauble = this.maid.getMaidBauble();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)maidBauble, i * 3 + j, 86 + 18 * j, 105 + 18 * i){

                    @OnlyIn(value=Dist.CLIENT)
                    public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                        return Pair.of((Object)InventoryMenu.f_39692_, (Object)ReloadResourceEvent.EMPTY_BAUBLE_SLOT);
                    }
                });
            }
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack stack1 = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack2 = slot.m_7993_();
            stack1 = stack2.m_41777_();
            if (index < 36 ? !this.m_38903_(stack2, 36, this.f_38839_.size(), false) : !this.m_38903_(stack2, 0, 36, true)) {
                return ItemStack.f_41583_;
            }
            if (stack2.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return stack1;
    }
}

