/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class ItemFilm
extends Item {
    public static final String MAID_INFO = "MaidInfo";

    public ItemFilm() {
        super(new Item.Properties().m_41491_(MaidGroup.MAIN_TAB).m_41487_(1));
    }

    public static ItemStack maidToFilm(EntityMaid maid) {
        ItemStack film = ((Item)InitItems.FILM.get()).m_7968_();
        CompoundTag filmTag = new CompoundTag();
        CompoundTag maidTag = new CompoundTag();
        maid.setHomeModeEnable(false);
        maid.m_7380_(maidTag);
        ItemFilm.removeMaidSomeData(maidTag);
        maidTag.m_128359_("id", Objects.requireNonNull(((EntityType)InitEntities.MAID.get()).getRegistryName()).toString());
        filmTag.m_128365_(MAID_INFO, (Tag)maidTag);
        film.m_41751_(filmTag);
        if (maid.m_8077_()) {
            film.m_41714_(maid.m_7770_());
        }
        return film;
    }

    private static boolean hasMaidData(ItemStack stack) {
        return stack.m_41782_() && !Objects.requireNonNull(stack.m_41783_()).m_128469_(MAID_INFO).m_128456_();
    }

    private static CompoundTag getMaidData(ItemStack stack) {
        if (ItemFilm.hasMaidData(stack)) {
            return Objects.requireNonNull(stack.m_41783_()).m_128469_(MAID_INFO);
        }
        return new CompoundTag();
    }

    private static void removeMaidSomeData(CompoundTag nbt) {
        nbt.m_128473_("MaidBackpackLevel");
        nbt.m_128473_("MaidInventory");
        nbt.m_128473_("MaidBaubleInventory");
        nbt.m_128473_("MaidExperience");
        nbt.m_128473_("ArmorItems");
        nbt.m_128473_("HandItems");
        nbt.m_128473_("Leash");
        nbt.m_128473_("Health");
        nbt.m_128473_("HurtTime");
        nbt.m_128473_("DeathTime");
        nbt.m_128473_("HurtByTimestamp");
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.m_20147_()) {
            entity.m_20331_(true);
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!ItemFilm.hasMaidData(stack)) {
            tooltip.add((Component)new TranslatableComponent("tooltips.touhou_little_maid.film.no_data.desc").m_130940_(ChatFormatting.DARK_RED));
        } else {
            String modelId;
            CompoundTag maidData = ItemFilm.getMaidData(stack);
            if (maidData.m_128425_("ModelId", 8) && StringUtils.isNotBlank((CharSequence)(modelId = maidData.m_128461_("ModelId")))) {
                CustomPackLoader.MAID_MODELS.getInfo(modelId).ifPresent(modelItem -> tooltip.add((Component)new TranslatableComponent("tooltips.touhou_little_maid.photo.maid.desc", new Object[]{I18n.m_118938_((String)ParseI18n.getI18nKey(modelItem.getName()), (Object[])new Object[0])}).m_130940_(ChatFormatting.GRAY)));
            }
        }
    }
}

