/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity.TileEntityItemStackGarageKitRenderer;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.IItemRenderProperties;

public class ItemGarageKit
extends BlockItem {
    private static final String ENTITY_INFO = "EntityInfo";
    private static final CompoundTag DEFAULT_DATA = ItemGarageKit.getDefaultData();

    public ItemGarageKit() {
        super((Block)InitBlocks.GARAGE_KIT.get(), new Item.Properties().m_41491_(MaidGroup.GARAGE_KIT_TAB).m_41487_(1));
    }

    private static boolean hasMaidData(ItemStack stack) {
        return stack.m_41782_() && !Objects.requireNonNull(stack.m_41783_()).m_128469_(ENTITY_INFO).m_128456_();
    }

    public static CompoundTag getMaidData(ItemStack stack) {
        if (ItemGarageKit.hasMaidData(stack)) {
            return Objects.requireNonNull(stack.m_41783_()).m_128469_(ENTITY_INFO);
        }
        return DEFAULT_DATA;
    }

    private static CompoundTag getDefaultData() {
        CompoundTag data = new CompoundTag();
        data.m_128359_("id", "touhou_little_maid:maid");
        data.m_128359_("ModelId", "touhou_little_maid:hakurei_reimu");
        return data;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                Minecraft minecraft = Minecraft.m_91087_();
                return new TileEntityItemStackGarageKitRenderer(minecraft.m_167982_(), minecraft.m_167973_());
            }
        });
    }
}

