/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.BackpackLevel;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ItemMaidBackpack
extends Item {
    private static final Map<Integer, ItemMaidBackpack> ITEM_BY_LEVEL = Maps.newHashMap();
    private final int level;

    public ItemMaidBackpack(int level) {
        super(new Item.Properties().m_41491_(MaidGroup.MAIN_TAB).m_41487_(1));
        this.level = level;
        ITEM_BY_LEVEL.put(level, this);
    }

    public static Optional<ItemMaidBackpack> getInstance(int level) {
        return Optional.ofNullable(ITEM_BY_LEVEL.get(level));
    }

    public int getLevel() {
        return this.level;
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        if (target instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)target;
            int maidBackpackLevel = maid.getBackpackLevel();
            if (maid.m_21830_((LivingEntity)playerIn) && this.level != maidBackpackLevel) {
                if (maid.backpackHasDelay()) {
                    return InteractionResult.SUCCESS;
                }
                maid.setBackpackLevel(this.level);
                maid.setBackpackDelay();
                for (Item item : ITEM_BY_LEVEL.values()) {
                    playerIn.m_36335_().m_41524_(item, 20);
                }
                stack.m_41774_(1);
                target.m_5496_(SoundEvents.f_12034_, 0.5f, 1.0f);
                ItemMaidBackpack.getInstance(maidBackpackLevel).ifPresent(backpack -> ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)backpack.m_7968_()));
                if (this.level < maidBackpackLevel) {
                    ItemStackHandler maidInv = maid.getMaidInv();
                    int n = BackpackLevel.BACKPACK_CAPACITY_MAP.get(this.level);
                    int endIndex = BackpackLevel.BACKPACK_CAPACITY_MAP.get(maidBackpackLevel);
                    ItemsUtil.dropEntityItems((Entity)maid, (IItemHandler)maidInv, n, endIndex);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6880_(stack, playerIn, target, hand);
    }
}

