/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemMaidBeacon
extends DoubleHighBlockItem {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private static final String STORAGE_DATA_TAG = "StorageData";
    private static final String FORGE_DATA_TAG = "ForgeData";

    public ItemMaidBeacon() {
        super((Block)InitBlocks.MAID_BEACON.get(), new Item.Properties().m_41487_(1).m_41491_(MaidGroup.MAIN_TAB));
    }

    public static ItemStack tileEntityToItemStack(TileEntityMaidBeacon beacon) {
        ItemStack stack = ((Item)InitItems.MAID_BEACON.get()).m_7968_();
        CompoundTag stackTag = stack.m_41784_();
        stackTag.m_128365_(STORAGE_DATA_TAG, (Tag)beacon.m_187482_());
        return stack;
    }

    public static void itemStackToTileEntity(ItemStack stack, TileEntityMaidBeacon beacon) {
        CompoundTag tag = stack.m_41698_(STORAGE_DATA_TAG);
        if (tag.m_128425_(FORGE_DATA_TAG, 10)) {
            beacon.loadData(tag.m_128469_(FORGE_DATA_TAG));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag forgeTag;
        float numPower = 0.0f;
        CompoundTag tag = stack.m_41698_(STORAGE_DATA_TAG);
        if (tag.m_128425_(FORGE_DATA_TAG, 10) && (forgeTag = tag.m_128469_(FORGE_DATA_TAG)).m_128425_("StoragePower", 5)) {
            numPower = forgeTag.m_128457_("StoragePower");
        }
        tooltip.add((Component)new TranslatableComponent("tooltips.touhou_little_maid.maid_beacon.desc", new Object[]{DECIMAL_FORMAT.format(numPower)}).m_130940_(ChatFormatting.GRAY));
    }
}

