/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.github.tartaricacid.touhoulittlemaid.util.PlaceHelper;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class ItemSmartSlab
extends Item {
    private static final String MAID_INFO = "MaidInfo";
    private static final String MAID_OWNER = "Owner";
    private final Type type;

    public ItemSmartSlab(Type type) {
        super(new Item.Properties().m_41491_(MaidGroup.MAIN_TAB).m_41487_(1));
        this.type = type;
    }

    public static void storeMaidData(ItemStack stack, EntityMaid maid) {
        maid.m_7380_(stack.m_41698_(MAID_INFO));
    }

    public static boolean hasMaidData(ItemStack stack) {
        return stack.m_41782_() && !Objects.requireNonNull(stack.m_41783_()).m_128469_(MAID_INFO).m_128456_();
    }

    public static CompoundTag getMaidData(ItemStack stack) {
        if (ItemSmartSlab.hasMaidData(stack)) {
            return Objects.requireNonNull(stack.m_41783_()).m_128469_(MAID_INFO);
        }
        return new CompoundTag();
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group) && this.type == Type.INIT) {
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public String m_5524_() {
        return "item.touhou_little_maid.smart_slab";
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Direction clickedFace = context.m_43719_();
        Player player = context.m_43723_();
        Level worldIn = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        if (player == null) {
            return super.m_6225_(context);
        }
        if (clickedFace == Direction.UP && !PlaceHelper.notSuitableForPlaceMaid(worldIn, clickedPos)) {
            EntityMaid maid = (EntityMaid)((EntityType)InitEntities.MAID.get()).m_20615_(worldIn);
            if (maid == null) {
                return super.m_6225_(context);
            }
            maid.m_20035_(clickedPos.m_7494_(), 0.0f, 0.0f);
            if (this.type == Type.INIT) {
                return this.spawnNewMaid(context, player, worldIn, maid);
            }
            if (this.type == Type.HAS_MAID) {
                return this.spawnFromStore(context, player, worldIn, maid);
            }
        } else if (worldIn.f_46443_) {
            player.m_6352_((Component)new TranslatableComponent("message.touhou_little_maid.photo.not_suitable_for_place_maid"), Util.f_137441_);
        }
        return super.m_6225_(context);
    }

    private InteractionResult spawnFromStore(UseOnContext context, Player player, Level worldIn, EntityMaid maid) {
        ItemStack stack = context.m_43722_();
        if (ItemSmartSlab.hasMaidData(stack)) {
            CompoundTag maidData = ItemSmartSlab.getMaidData(stack);
            UUID ownerUid = maidData.m_128342_(MAID_OWNER);
            if (!player.m_142081_().equals(ownerUid)) {
                return InteractionResult.FAIL;
            }
            maid.m_7378_(maidData);
            if (stack.m_41788_()) {
                maid.m_6593_(stack.m_41786_());
            }
            if (worldIn instanceof ServerLevel) {
                worldIn.m_7967_((Entity)maid);
            }
            maid.spawnExplosionParticle();
            maid.m_5496_(SoundEvents.f_12277_, 1.0f, worldIn.f_46441_.nextFloat() * 0.1f + 0.9f);
            player.m_21008_(context.m_43724_(), ((Item)InitItems.SMART_SLAB_EMPTY.get()).m_7968_());
            player.m_36335_().m_41524_((Item)InitItems.SMART_SLAB_EMPTY.get(), 20);
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return super.m_6225_(context);
    }

    private InteractionResult spawnNewMaid(UseOnContext context, Player player, Level worldIn, EntityMaid maid) {
        return player.getCapability(MaidNumCapabilityProvider.MAID_NUM_CAP).map(cap -> {
            if (cap.canAdd() || player.m_7500_()) {
                if (!player.m_7500_()) {
                    cap.add();
                }
                maid.m_21828_(player);
                if (worldIn instanceof ServerLevel) {
                    maid.m_6518_((ServerLevelAccessor)((ServerLevel)worldIn), worldIn.m_6436_(context.m_8083_()), MobSpawnType.SPAWN_EGG, null, null);
                    worldIn.m_7967_((Entity)maid);
                }
                maid.spawnExplosionParticle();
                maid.m_5496_(SoundEvents.f_12277_, 1.0f, worldIn.f_46441_.nextFloat() * 0.1f + 0.9f);
                player.m_21008_(context.m_43724_(), ((Item)InitItems.SMART_SLAB_EMPTY.get()).m_7968_());
                player.m_36335_().m_41524_((Item)InitItems.SMART_SLAB_EMPTY.get(), 20);
                return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
            }
            if (worldIn.f_46443_) {
                player.m_6352_((Component)new TranslatableComponent("message.touhou_little_maid.owner_maid_num.can_not_add", new Object[]{cap.get(), cap.getMaxNum()}), Util.f_137441_);
            }
            return super.m_6225_(context);
        }).orElse(super.m_6225_(context));
    }

    public boolean m_5812_(ItemStack stack) {
        return this.type != Type.EMPTY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        String modelId;
        CompoundTag maidData;
        if (this.type == Type.INIT) {
            TranslatableComponent text = new TranslatableComponent("tooltips.touhou_little_maid.smart_slab.maid_name", new Object[]{I18n.m_118938_((String)"tooltips.touhou_little_maid.smart_slab.maid_name.unknown", (Object[])new Object[0])});
            tooltip.add((Component)text.m_130940_(ChatFormatting.GRAY));
        }
        if (this.type == Type.HAS_MAID && (maidData = ItemSmartSlab.getMaidData(stack)).m_128425_("ModelId", 8) && StringUtils.isNotBlank((CharSequence)(modelId = ItemSmartSlab.getMaidData(stack).m_128461_("ModelId")))) {
            CustomPackLoader.MAID_MODELS.getInfo(modelId).ifPresent(info -> {
                String modelNameKey = ParseI18n.getI18nKey(info.getName());
                TranslatableComponent text = new TranslatableComponent("tooltips.touhou_little_maid.smart_slab.maid_name", new Object[]{I18n.m_118938_((String)modelNameKey, (Object[])new Object[0])});
                tooltip.add((Component)text.m_130940_(ChatFormatting.GRAY));
            });
        }
        tooltip.add((Component)new TranslatableComponent("tooltips.touhou_little_maid.smart_slab.desc").m_130940_(ChatFormatting.GRAY));
    }

    public static enum Type {
        INIT,
        EMPTY,
        HAS_MAID;

    }
}

