/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAttackEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class NimbleFabricBauble
implements IMaidBauble {
    private static final int MAX_RETRY = 16;

    public NimbleFabricBauble() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingDamage(MaidAttackEvent event) {
        int slot;
        EntityMaid maid = event.getMaid();
        DamageSource source = event.getSource();
        if (source instanceof IndirectEntityDamageSource && (slot = ItemsUtil.getBaubleSlotInMaid(maid, this)) >= 0) {
            event.setCanceled(true);
            ItemStack stack = maid.getMaidBauble().getStackInSlot(slot);
            stack.m_41622_(1, (LivingEntity)maid, m -> maid.sendItemBreakMessage(stack));
            maid.getMaidBauble().setStackInSlot(slot, stack);
            for (int i = 0; i < 16; ++i) {
                if (!this.teleport(maid)) continue;
                return;
            }
        }
    }

    protected boolean teleport(EntityMaid maid) {
        if (!maid.f_19853_.m_5776_() && maid.m_6084_()) {
            double x = maid.m_20185_() + (maid.m_21187_().nextDouble() - 0.5) * 16.0;
            double y = maid.m_20186_() + (double)maid.m_21187_().nextInt(16) - 8.0;
            double z = maid.m_20189_() + (maid.m_21187_().nextDouble() - 0.5) * 16.0;
            return this.teleport(maid, x, y, z);
        }
        return false;
    }

    private boolean teleport(EntityMaid maid, double x, double y, double z) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(x, y, z);
        while (blockPos.m_123342_() > maid.f_19853_.m_141937_() && !maid.f_19853_.m_8055_((BlockPos)blockPos).m_60767_().m_76334_()) {
            blockPos.m_122173_(Direction.DOWN);
        }
        BlockState blockState = maid.f_19853_.m_8055_((BlockPos)blockPos);
        boolean isMotion = blockState.m_60767_().m_76334_();
        boolean isWater = blockState.m_60819_().m_205070_(FluidTags.f_13131_);
        if (isMotion && !isWater) {
            boolean teleportIsSuccess = maid.m_20984_(x, y, z, true);
            if (teleportIsSuccess && !maid.m_20067_()) {
                maid.f_19853_.m_6263_(null, maid.f_19854_, maid.f_19855_, maid.f_19856_, SoundEvents.f_11852_, maid.m_5720_(), 1.0f, 1.0f);
                maid.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return teleportIsSuccess;
        }
        return false;
    }
}

