/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.loot;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class AdditionLootModifier
extends LootModifier {
    private final ResourceLocation parameterSet;
    private final ResourceLocation additionLootTable;

    public AdditionLootModifier(LootItemCondition[] conditionsIn, ResourceLocation parameterSet, ResourceLocation additionLootTable) {
        super(conditionsIn);
        this.parameterSet = parameterSet;
        this.additionLootTable = additionLootTable;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation currentLootTable = context.getQueriedLootTableId();
        if (!currentLootTable.equals((Object)this.additionLootTable) && this.parameterSetEquals(context)) {
            LootTable additionTable = context.m_78940_(this.additionLootTable);
            generatedLoot.addAll(additionTable.m_79129_(context));
        }
        return generatedLoot;
    }

    private boolean parameterSetEquals(LootContext context) {
        ResourceLocation currentLootTable = context.getQueriedLootTableId();
        LootTable lootTable = context.m_78940_(currentLootTable);
        return Objects.equals(lootTable.m_79122_(), LootContextParamSets.m_81431_((ResourceLocation)this.parameterSet));
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AdditionLootModifier> {
        public AdditionLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            String parameterSet = GsonHelper.m_13906_((JsonObject)object, (String)"parameter_set_name");
            String additionLootTable = GsonHelper.m_13906_((JsonObject)object, (String)"addition_loot_table");
            return new AdditionLootModifier(conditions, new ResourceLocation(parameterSet), new ResourceLocation(additionLootTable));
        }

        public JsonObject write(AdditionLootModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            object.addProperty("parameter_set_name", instance.parameterSet.toString());
            object.addProperty("addition_loot_table", instance.additionLootTable.toString());
            return object;
        }
    }
}

