/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class MaidModelMessage {
    private final int id;
    private final ResourceLocation modelId;

    public MaidModelMessage(int id, ResourceLocation modelId) {
        this.id = id;
        this.modelId = modelId;
    }

    public static void encode(MaidModelMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.id);
        buf.m_130085_(message.modelId);
    }

    public static MaidModelMessage decode(FriendlyByteBuf buf) {
        return new MaidModelMessage(buf.readInt(), buf.m_130281_());
    }

    public static void handle(MaidModelMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.f_19853_.m_6815_(message.id);
                if (entity instanceof EntityMaid && ((EntityMaid)entity).m_21830_((LivingEntity)sender)) {
                    if (sender.m_7500_() || ((Boolean)MaidConfig.MAID_CHANGE_MODEL.get()).booleanValue()) {
                        ((EntityMaid)entity).setModelId(message.modelId.toString());
                    } else {
                        sender.m_9146_((Component)new TranslatableComponent("message.touhou_little_maid.change_model.disabled"), ChatType.GAME_INFO, Util.f_137441_);
                    }
                }
            });
        }
        context.setPacketHandled(true);
    }
}

