/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Items;
import net.minecraftforge.network.NetworkEvent;

public class SendNameTagMessage {
    private static final int MAX_STRING_LENGTH = 1024;
    private final int id;
    private final String name;
    private final boolean alwaysShow;

    public SendNameTagMessage(int id, String name, boolean alwaysShow) {
        this.id = id;
        this.name = name;
        this.alwaysShow = alwaysShow;
    }

    public static void encode(SendNameTagMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.id);
        buf.m_130072_(message.name, 1024);
        buf.writeBoolean(message.alwaysShow);
    }

    public static SendNameTagMessage decode(FriendlyByteBuf buf) {
        return new SendNameTagMessage(buf.readInt(), buf.m_130136_(1024), buf.readBoolean());
    }

    public static void handle(SendNameTagMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.f_19853_.m_6815_(message.id);
                if (entity instanceof EntityMaid) {
                    SendNameTagMessage.setMaidNameTag(message, sender, (EntityMaid)entity);
                }
            });
        }
        context.setPacketHandled(true);
    }

    private static void setMaidNameTag(SendNameTagMessage message, ServerPlayer player, EntityMaid maid) {
        String name = message.name.substring(0, Math.min(32, message.name.length()));
        if (player.equals((Object)maid.m_142480_()) && player.m_21205_().m_41720_() == Items.f_42656_) {
            maid.m_6593_((Component)new TextComponent(name));
            maid.m_20340_(message.alwaysShow);
            maid.m_21530_();
            player.m_21205_().m_41774_(1);
        }
    }
}

