/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapability;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class StorageAndTakePowerMessage {
    private final BlockPos pos;
    private final float powerNum;
    private final boolean isStorage;

    public StorageAndTakePowerMessage(BlockPos pos, float powerNum, boolean isStorage) {
        this.pos = pos;
        this.powerNum = powerNum;
        this.isStorage = isStorage;
    }

    public static void encode(StorageAndTakePowerMessage message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.writeFloat(message.powerNum);
        buf.writeBoolean(message.isStorage);
    }

    public static StorageAndTakePowerMessage decode(FriendlyByteBuf buf) {
        return new StorageAndTakePowerMessage(buf.m_130135_(), buf.readFloat(), buf.readBoolean());
    }

    public static void handle(StorageAndTakePowerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                BlockEntity te;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Level world = sender.f_19853_;
                if (world.m_46749_(message.pos) && (te = world.m_7702_(message.pos)) instanceof TileEntityMaidBeacon) {
                    TileEntityMaidBeacon beacon = (TileEntityMaidBeacon)te;
                    sender.getCapability(PowerCapabilityProvider.POWER_CAP).ifPresent(power -> {
                        if (message.isStorage) {
                            StorageAndTakePowerMessage.storageLogic(message.powerNum, power, beacon);
                        } else {
                            StorageAndTakePowerMessage.takeLogic(message.powerNum, power, beacon);
                        }
                    });
                }
            });
        }
        context.setPacketHandled(true);
    }

    private static void storageLogic(float powerNum, PowerCapability playerPower, TileEntityMaidBeacon beacon) {
        boolean beaconNotFull;
        boolean playerPowerIsEnough = powerNum <= playerPower.get();
        boolean bl = beaconNotFull = powerNum + beacon.getStoragePower() <= beacon.getMaxStorage();
        if (playerPowerIsEnough) {
            if (beaconNotFull) {
                playerPower.min(powerNum);
                beacon.setStoragePower(beacon.getStoragePower() + powerNum);
            } else {
                playerPower.min(beacon.getMaxStorage() - beacon.getStoragePower());
                beacon.setStoragePower(beacon.getMaxStorage());
            }
        }
    }

    private static void takeLogic(float powerNum, PowerCapability playerPower, TileEntityMaidBeacon beacon) {
        boolean playerNotFull;
        boolean beaconIsEnough = powerNum <= beacon.getStoragePower();
        boolean bl = playerNotFull = powerNum + playerPower.get() < 5.0f;
        if (beaconIsEnough) {
            if (playerNotFull) {
                beacon.setStoragePower(beacon.getStoragePower() - powerNum);
                playerPower.add(powerNum);
            } else {
                beacon.setStoragePower(beacon.getStoragePower() - 5.0f + playerPower.get());
                playerPower.set(5.0f);
            }
        }
    }
}

