/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SyncCapabilityMessage {
    private final float power;
    private final int maidNum;

    public SyncCapabilityMessage(float power, int maidNum) {
        this.power = power;
        this.maidNum = maidNum;
    }

    public static void encode(SyncCapabilityMessage message, FriendlyByteBuf buf) {
        buf.writeFloat(message.power);
        buf.m_130130_(message.maidNum);
    }

    public static SyncCapabilityMessage decode(FriendlyByteBuf buf) {
        return new SyncCapabilityMessage(buf.readFloat(), buf.m_130242_());
    }

    public static void handle(SyncCapabilityMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> SyncCapabilityMessage.handleCapability(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleCapability(SyncCapabilityMessage message) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        mc.f_91074_.getCapability(PowerCapabilityProvider.POWER_CAP).ifPresent(cap -> cap.set(message.power));
        mc.f_91074_.getCapability(MaidNumCapabilityProvider.MAID_NUM_CAP).ifPresent(cap -> cap.set(message.maidNum));
    }
}

