/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityModelSwitcher
extends BlockEntity {
    public static final String INFO_LIST = "info_list";
    public static final BlockEntityType<TileEntityModelSwitcher> TYPE = BlockEntityType.Builder.m_155273_(TileEntityModelSwitcher::new, (Block[])new Block[]{(Block)InitBlocks.MODEL_SWITCHER.get()}).m_58966_(null);
    public static final String ENTITY_UUID = "entity_uuid";
    public static final String LIST_INDEX = "list_index";
    private List<ModeInfo> infoList = Lists.newArrayList();
    private boolean isPowered;
    private UUID uuid;
    private int index;

    public TileEntityModelSwitcher(BlockPos pWorldPosition, BlockState pBlockState) {
        super(TYPE, pWorldPosition, pBlockState);
    }

    protected void m_183515_(CompoundTag pTag) {
        ListTag listTag = new ListTag();
        for (ModeInfo info : this.infoList) {
            listTag.add((Object)info.serialize());
        }
        this.getTileData().m_128365_(INFO_LIST, (Tag)listTag);
        if (this.uuid != null) {
            this.getTileData().m_128365_(ENTITY_UUID, (Tag)NbtUtils.m_129226_((UUID)this.uuid));
        }
        this.getTileData().m_128405_(LIST_INDEX, this.index);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.infoList.clear();
        ListTag listTag = this.getTileData().m_128437_(INFO_LIST, 10);
        for (int i = 0; i < listTag.size(); ++i) {
            ModeInfo info = new ModeInfo();
            info.deserialize(listTag.m_128728_(i));
            this.infoList.add(info);
        }
        Tag uuidTag = this.getTileData().m_128423_(ENTITY_UUID);
        if (uuidTag != null) {
            this.uuid = NbtUtils.m_129233_((Tag)uuidTag);
        }
        this.index = this.getTileData().m_128451_(LIST_INDEX);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nullable
    public UUID getUuid() {
        return this.uuid;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
        this.refresh();
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void setPowered(boolean powered) {
        this.isPowered = powered;
    }

    @Nullable
    public ModeInfo getModelInfo() {
        if (0 <= this.index && this.index < this.infoList.size()) {
            return this.infoList.get(this.index);
        }
        return null;
    }

    public List<ModeInfo> getInfoList() {
        return this.infoList;
    }

    public void setInfoList(List<ModeInfo> infoList) {
        this.infoList = infoList;
        this.refresh();
    }

    public void refresh() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public static class ModeInfo {
        private ResourceLocation modelId;
        private String text;
        private Direction direction;

        public ModeInfo() {
        }

        public ModeInfo(ResourceLocation modelId, String text, Direction direction) {
            this.modelId = modelId;
            this.text = text;
            this.direction = direction;
        }

        public static ModeInfo fromBuf(FriendlyByteBuf buf) {
            return new ModeInfo(buf.m_130281_(), buf.m_130277_(), Direction.m_122407_((int)buf.m_130242_()));
        }

        public ResourceLocation getModelId() {
            return this.modelId;
        }

        public void setModelId(ResourceLocation modelId) {
            this.modelId = modelId;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        public void toBuf(FriendlyByteBuf buf) {
            buf.m_130085_(this.modelId);
            buf.m_130070_(this.text);
            buf.m_130130_(this.direction.m_122416_());
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("model_id", this.modelId.toString());
            tag.m_128359_("text", this.text);
            tag.m_128405_("direction", this.direction.m_122416_());
            return tag;
        }

        public void deserialize(CompoundTag nbt) {
            this.modelId = new ResourceLocation(nbt.m_128461_("model_id"));
            this.text = nbt.m_128461_("text");
            this.direction = Direction.m_122407_((int)nbt.m_128451_("direction"));
        }
    }
}

