/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityStatue
extends BlockEntity {
    private static final String STATUE_SIZE_TAG = "StatueSize";
    public static final BlockEntityType<TileEntityStatue> TYPE = BlockEntityType.Builder.m_155273_(TileEntityStatue::new, (Block[])new Block[]{(Block)InitBlocks.STATUE.get()}).m_58966_(null);
    private static final String CORE_BLOCK_TAG = "CoreBlock";
    private static final String CORE_BLOCK_POS_TAG = "CoreBlockPos";
    private static final String STATUE_FACING_TAG = "StatueFacing";
    private static final String ALL_BLOCKS_TAG = "AllBlocks";
    private static final String EXTRA_MAID_DATA = "ExtraMaidData";
    private Size size = Size.SMALL;
    private boolean isCoreBlock = false;
    private BlockPos coreBlockPos = BlockPos.f_121853_;
    private Direction facing = Direction.NORTH;
    private List<BlockPos> allBlocks = Lists.newArrayList();
    @Nullable
    private CompoundTag extraMaidData = null;

    public TileEntityStatue(BlockPos blockPos, BlockState blockState) {
        super(TYPE, blockPos, blockState);
    }

    public void setForgeData(Size size, boolean isCoreBlock, BlockPos coreBlockPos, Direction facing, List<BlockPos> allBlocks, @Nullable CompoundTag extraData) {
        this.size = size;
        this.isCoreBlock = isCoreBlock;
        this.coreBlockPos = coreBlockPos;
        this.facing = facing;
        this.allBlocks = allBlocks;
        this.extraMaidData = extraData;
        this.refresh();
    }

    public void m_183515_(CompoundTag compound) {
        this.getTileData().m_128405_(STATUE_SIZE_TAG, this.size.ordinal());
        this.getTileData().m_128379_(CORE_BLOCK_TAG, this.isCoreBlock);
        this.getTileData().m_128365_(CORE_BLOCK_POS_TAG, (Tag)NbtUtils.m_129224_((BlockPos)this.coreBlockPos));
        this.getTileData().m_128359_(STATUE_FACING_TAG, this.facing.m_7912_());
        ListTag blockList = new ListTag();
        for (BlockPos pos : this.allBlocks) {
            blockList.add((Object)NbtUtils.m_129224_((BlockPos)pos));
        }
        this.getTileData().m_128365_(ALL_BLOCKS_TAG, (Tag)blockList);
        if (this.extraMaidData != null) {
            this.getTileData().m_128365_(EXTRA_MAID_DATA, (Tag)this.extraMaidData);
        }
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.size = Size.getSizeByIndex(this.getTileData().m_128451_(STATUE_SIZE_TAG));
        this.isCoreBlock = this.getTileData().m_128471_(CORE_BLOCK_TAG);
        this.coreBlockPos = NbtUtils.m_129239_((CompoundTag)this.getTileData().m_128469_(CORE_BLOCK_POS_TAG));
        this.facing = Direction.m_122402_((String)this.getTileData().m_128461_(STATUE_FACING_TAG));
        this.allBlocks.clear();
        ListTag blockList = this.getTileData().m_128437_(ALL_BLOCKS_TAG, 10);
        for (int i = 0; i < blockList.size(); ++i) {
            this.allBlocks.add(NbtUtils.m_129239_((CompoundTag)blockList.m_128728_(i)));
        }
        if (this.getTileData().m_128425_(EXTRA_MAID_DATA, 10)) {
            this.extraMaidData = this.getTileData().m_128469_(EXTRA_MAID_DATA);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_142082_(-5, -1, -5), this.f_58858_.m_142082_(5, 10, 5));
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void refresh() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public Size getSize() {
        return this.size;
    }

    public boolean isCoreBlock() {
        return this.isCoreBlock;
    }

    public BlockPos getCoreBlockPos() {
        return this.coreBlockPos;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public List<BlockPos> getAllBlocks() {
        return this.allBlocks;
    }

    @Nullable
    public CompoundTag getExtraMaidData() {
        return this.extraMaidData;
    }

    public static enum Size {
        TINY(0.5f, new Vec3i(1, 1, 1)),
        SMALL(1.0f, new Vec3i(1, 2, 1)),
        MIDDLE(2.0f, new Vec3i(2, 4, 2)),
        BIG(3.0f, new Vec3i(3, 6, 3));

        private final float scale;
        private final Vec3i dimension;

        private Size(float scale, Vec3i dimension) {
            this.scale = scale;
            this.dimension = dimension;
        }

        public static Size getSizeByIndex(int index) {
            return Size.values()[Mth.m_14045_((int)index, (int)0, (int)(Size.values().length - 1))];
        }

        public float getScale() {
            return this.scale;
        }

        public Vec3i getDimension() {
            return this.dimension;
        }
    }
}

