/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public final class SoundUtil {
    private static final long MORNING_START = 0L;
    private static final long MORNING_END = 3000L;
    private static final long EVENING_START = 12000L;
    private static final long EVENING_END = 15000L;

    public static SoundEvent environmentSound(EntityMaid maid, SoundEvent fallback, float probability) {
        Level world = maid.f_19853_;
        Random rand = maid.m_21187_();
        BlockPos pos = maid.m_142538_();
        long dayTime = world.m_46468_();
        Biome biome = (Biome)world.m_204166_(pos).m_203334_();
        if (rand.nextFloat() < probability && 0L < dayTime && dayTime < 3000L) {
            return (SoundEvent)InitSounds.MAID_MORNING.get();
        }
        if (rand.nextFloat() < probability && 12000L < dayTime && dayTime < 15000L) {
            return (SoundEvent)InitSounds.MAID_NIGHT.get();
        }
        if (rand.nextFloat() < probability && world.m_46471_() && SoundUtil.isRainBiome(biome, pos)) {
            return (SoundEvent)InitSounds.MAID_RAIN.get();
        }
        if (rand.nextFloat() < probability && world.m_46471_() && SoundUtil.isSnowyBiome(biome, pos)) {
            return (SoundEvent)InitSounds.MAID_SNOW.get();
        }
        if (rand.nextFloat() < probability && biome.m_198904_(pos)) {
            return (SoundEvent)InitSounds.MAID_COLD.get();
        }
        if (rand.nextFloat() < probability && biome.m_198910_(pos)) {
            return (SoundEvent)InitSounds.MAID_HOT.get();
        }
        return fallback;
    }

    public static SoundEvent attackSound(EntityMaid maid, SoundEvent fallback, float probability) {
        Random rand = maid.m_21187_();
        if (rand.nextFloat() < probability) {
            return (SoundEvent)InitSounds.MAID_FIND_TARGET.get();
        }
        return fallback;
    }

    public static boolean isRainBiome(Biome biome, BlockPos pos) {
        return biome.m_47530_() == Biome.Precipitation.RAIN && biome.m_198906_(pos) && !biome.m_198910_(pos);
    }

    public static boolean isSnowyBiome(Biome biome, BlockPos pos) {
        return biome.m_47530_() == Biome.Precipitation.SNOW && biome.m_198904_(pos);
    }
}

