/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.client.audio;

import com.github.tartaricacid.netmusic.config.GeneralConfig;
import com.github.tartaricacid.netmusic.soundlibs.javazoom.spi.mpeg.sampled.file.MpegAudioFileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.client.sounds.AudioStream;
import org.apache.commons.compress.utils.IOUtils;
import org.lwjgl.BufferUtils;

public class Mp3AudioStream
implements AudioStream {
    private final AudioInputStream stream;
    private final byte[] array;
    private int offset;

    public Mp3AudioStream(URL url) throws UnsupportedAudioFileException, IOException {
        AudioInputStream originalInputStream = new MpegAudioFileReader().getAudioInputStream(url);
        AudioFormat originalFormat = originalInputStream.getFormat();
        AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, originalFormat.getSampleRate(), 16, originalFormat.getChannels(), originalFormat.getChannels() * 2, originalFormat.getSampleRate(), false);
        AudioInputStream targetInputStream = AudioSystem.getAudioInputStream(targetFormat, originalInputStream);
        if (((Boolean)GeneralConfig.ENABLE_STEREO.get()).booleanValue()) {
            targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, originalFormat.getSampleRate(), 16, 1, 2, originalFormat.getSampleRate(), false);
            this.stream = AudioSystem.getAudioInputStream(targetFormat, targetInputStream);
        } else {
            this.stream = targetInputStream;
        }
        this.array = IOUtils.toByteArray((InputStream)this.stream);
        this.offset = 0;
    }

    public AudioFormat m_6206_() {
        return this.stream.getFormat();
    }

    public ByteBuffer m_7118_(int size) {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)size);
        if (this.array.length >= this.offset + size) {
            byteBuffer.put(this.array, this.offset, size);
        } else {
            byteBuffer.put(new byte[size]);
        }
        this.offset += size;
        byteBuffer.flip();
        return byteBuffer;
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

