/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.client.gui;

import com.github.tartaricacid.netmusic.client.config.MusicListManage;
import com.github.tartaricacid.netmusic.inventory.CDBurnerMenu;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.network.NetworkHandler;
import com.github.tartaricacid.netmusic.network.message.SetMusicIDMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.commons.lang3.StringUtils;

public class CDBurnerMenuScreen
extends AbstractContainerScreen<CDBurnerMenu> {
    private static final ResourceLocation BG = new ResourceLocation("netmusic", "textures/gui/cd_burner.png");
    private static final Pattern ID_REG = Pattern.compile("^\\d{4,}$");
    private static final Pattern URL_1_REG = Pattern.compile("^https://music\\.163\\.com/song\\?id=(\\d+).*$");
    private static final Pattern URL_2_REG = Pattern.compile("^https://music\\.163\\.com/#/song\\?id=(\\d+).*$");
    private EditBox textField;
    private Component tips = TextComponent.f_131282_;

    public CDBurnerMenuScreen(CDBurnerMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    protected void m_7856_() {
        super.m_7856_();
        String perText = "";
        boolean focus = false;
        if (this.textField != null) {
            perText = this.textField.m_94155_();
            focus = this.textField.m_93696_();
        }
        this.textField = new EditBox(this.getMinecraft().f_91062_, this.f_97735_ + 12, this.f_97736_ + 18, 132, 16, (Component)new TextComponent("Music ID Box")){

            public void m_94164_(String text) {
                Matcher matcher1 = URL_1_REG.matcher(text);
                if (matcher1.find()) {
                    String group = matcher1.group(1);
                    super.m_94164_(group);
                    return;
                }
                Matcher matcher2 = URL_2_REG.matcher(text);
                if (matcher2.find()) {
                    String group = matcher2.group(1);
                    super.m_94164_(group);
                    return;
                }
                super.m_94164_(text);
            }
        };
        this.textField.m_94144_(perText);
        this.textField.m_94182_(false);
        this.textField.m_94199_(19);
        this.textField.m_94202_(15986656);
        this.textField.m_94178_(focus);
        this.textField.m_94201_();
        this.m_7787_((GuiEventListener)this.textField);
        this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 7, this.f_97736_ + 33, 135, 20, (Component)new TranslatableComponent("gui.netmusic.cd_burner.craft"), b -> this.handleCraftButton()));
    }

    private void handleCraftButton() {
        if (StringUtils.isBlank((CharSequence)this.textField.m_94155_())) {
            this.tips = new TranslatableComponent("gui.netmusic.cd_burner.no_music_id");
            return;
        }
        if (ID_REG.matcher(this.textField.m_94155_()).matches()) {
            long id = Long.parseLong(this.textField.m_94155_());
            try {
                ItemMusicCD.SongInfo song = MusicListManage.get163Song(id);
                NetworkHandler.CHANNEL.sendToServer((Object)new SetMusicIDMessage(song));
            }
            catch (Exception e) {
                this.tips = new TranslatableComponent("gui.netmusic.cd_burner.get_info_error");
                e.printStackTrace();
            }
        } else {
            this.tips = new TranslatableComponent("gui.netmusic.cd_burner.music_id_error");
        }
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
    }

    protected void m_7286_(PoseStack pPoseStack, float pPartialTicks, int pX, int pY) {
        this.m_7333_(pPoseStack);
        int posX = this.f_97735_;
        int posY = (this.f_96544_ - this.f_97727_) / 2;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BG);
        this.m_93228_(pPoseStack, posX, posY, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTicks) {
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTicks);
        this.textField.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTicks);
        if (StringUtils.isBlank((CharSequence)this.textField.m_94155_()) && !this.textField.m_93696_()) {
            CDBurnerMenuScreen.m_93243_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)new TranslatableComponent("gui.netmusic.cd_burner.id.tips").m_130940_(ChatFormatting.ITALIC), (int)(this.f_97735_ + 12), (int)(this.f_97736_ + 18), (int)ChatFormatting.GRAY.m_126665_());
        }
        this.f_96547_.m_92857_((FormattedText)this.tips, this.f_97735_ + 8, this.f_97736_ + 55, 135, 0xCF0000);
        this.m_7025_(pPoseStack, pMouseX, pMouseY);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String value = this.textField.m_94155_();
        super.m_6574_(minecraft, width, height);
        this.textField.m_94144_(value);
    }

    protected void m_181908_() {
        this.textField.m_94120_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.textField.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.textField);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_6697_(String text, boolean overwrite) {
        if (overwrite) {
            this.textField.m_94144_(text);
        } else {
            this.textField.m_94164_(text);
        }
    }
}

